import axios from "axios";
import { Loading, Message } from "element-ui";
import { blobValidate } from "@/utils/ruoyi";

/**
 * @description 下载文件方法
 * @param path 文件路径
 * */
let downloadLoadingInstance;

export function downLoadFile(path, fileName) {
  downloadLoadingInstance = Loading.service({
    text: "正在下载数据，请稍候",
    spinner: "el-icon-loading",
    background: "rgba(0, 0, 0, 0.7)",
  })
  return axios.get(path, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    responseType: "blob"
  }).then(async (response) => {
    const isLogin = await blobValidate(response.data);
    if (isLogin) {
      const blob = new Blob([response.data]);
      saveAs(blob, fileName);
    }
    downloadLoadingInstance.close();
  }).catch((r) => {
    r.response && Message.error('下载文件出现错误，请联系管理员！');
    downloadLoadingInstance.close();
  });

}
