import {login, logout, getInfo} from '@/api/login'
import {getToken, setToken, removeToken} from '@/utils/auth'

const user = {
  state: {
    token: getToken(),
    name: '',
    employeeType: '',
    avatar: '',
    sign: '',
    roles: [],
    permissions: [],
    roleKey: '',
    roleId: '',
    deptId: '',
    userId: '',
    teacher: {},
    education: '',
    sex: "",
  },

  mutations: {
    SET_TOKEN: (state, token) => {
      state.token = token
    },
    SET_NAME: (state, name) => {
      state.name = name
    },
    SET_EDUCATION: (state, education) => {
      state.education = education
    },
    SET_EMPLOYEETYPE: (state, employeeType) => {
      state.employeeType = employeeType
    },
    SET_AVATAR: (state, avatar) => {
      state.avatar = avatar
    },
    SET_SIGN: (state, sign) => {
      state.sign = sign
    },
    SET_ROLES: (state, roles) => {
      state.roles = roles
    },
    SET_PERMISSIONS: (state, permissions) => {
      state.permissions = permissions
    },

    SET_USER: (state, info) => {
      state.deptId = info.deptId;
      state.roleId = info.roleId;
      state.userId = info.userId;
      state.roleKey = info.roleKey;
    },
    SET_TEACHER: (state, teacher) => {
      state.teacher = teacher;
    },
    SET_SEX: (state, sex) => {
      state.sex = sex;
    }
  },

  actions: {
    // 登录
    Login({commit}, userInfo) {
      // const username = userInfo.username.trim()
      const phonenumber = userInfo.phonenumber.trim()
      const password = userInfo.password
      const code = userInfo.code
      const uuid = userInfo.uuid
      return new Promise((resolve, reject) => {
        login(phonenumber, password, code, uuid).then(res => {
          setToken(res.token)
          commit('SET_TOKEN', res.token)
          resolve()
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 获取用户信息
    GetInfo({commit, state}) {
      return new Promise((resolve, reject) => {
        getInfo().then(res => {
          // console.log(res, 81)
          const user = res.user
          const teacher = res.teacher
          const avatar = (user.avatar == "" || user.avatar == null) ? require("@/assets/images/profile.jpg") : process.env.VUE_APP_BASE_API + user.avatar;
          const sign = (user.sign == "" || user.sign == null) ? require("@/assets/images/profile.jpg") : process.env.VUE_APP_BASE_API + user.sign;
          if (res.roles && res.roles.length > 0) { // 验证返回的roles是否是一个非空数组
            commit('SET_ROLES', res.roles)
            commit('SET_PERMISSIONS', res.permissions)
          } else {
            commit('SET_ROLES', ['ROLE_DEFAULT'])
          }
          commit('SET_SEX', user.sex)
          commit('SET_NAME', user.userName)
          commit('SET_EDUCATION', teacher.education)
          commit('SET_EMPLOYEETYPE', user.employeeType)

          commit('SET_AVATAR', avatar)
          commit('SET_SIGN', sign)
          commit('SET_USER', {
            deptId: user.deptId,
            roleId: user.roles[0] && user.roles[0].roleId,
            userId: user.userId,
            roleKey: res.roles[0]
          })
          commit('SET_TEACHER', {
            ...res.teacher,
            deptName: user.dept.deptName,
            roles: user.roles.map(item => item.roleName).join('、')
          })
          resolve(res)
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 退出系统
    LogOut({commit, state}) {
      return new Promise((resolve, reject) => {
        logout(state.token).then(() => {
          commit('SET_TOKEN', '')
          commit('SET_ROLES', [])
          commit('SET_PERMISSIONS', [])
          removeToken()
          resolve()
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 前端 登出
    FedLogOut({commit}) {
      return new Promise(resolve => {
        commit('SET_TOKEN', '')
        removeToken()
        resolve()
      })
    }
  }
}

export default user
