import request from '@/utils/request'

// 查询教师工资列表
export function listTeacherWages(query) {
  return request({
    url: '/school/teacherWages/list',
    method: 'get',
    params: query
  })
}

// 查询教师工资详细
export function getTeacherWages(id) {
  return request({
    url: '/school/teacherWages/queryOne/' + id,
    method: 'get'
  })
}

// 新增教师工资
export function addTeacherWages(data) {
  return request({
    url: '/school/teacherWages/add',
    method: 'post',
    data: data
  })
}

// 修改教师工资
export function updateTeacherWages(data) {
  return request({
    url: '/school/teacherWages/edit',
    method: 'put',
    data: data
  })
}

// 删除教师工资
export function delTeacherWages(id) {
  return request({
    url: '/school/teacherWages/delete/' + id,
    method: 'delete'
  })
}
