import request from '@/utils/request'

// 查询教师加班列表
export function listTeacherOvertime(query) {
  return request({
    url: '/school/teacherOvertime/list',
    method: 'get',
    params: query
  })
}

// 查询教师加班详细
export function getTeacherOvertime(id) {
  return request({
    url: '/school/teacherOvertime/queryOne/' + id,
    method: 'get'
  })
}

// 新增教师加班
export function addTeacherOvertime(data) {
  return request({
    url: '/school/teacherOvertime/add',
    method: 'post',
    data: data
  })
}

// 修改教师加班
export function updateTeacherOvertime(data) {
  return request({
    url: '/school/teacherOvertime/edit',
    method: 'put',
    data: data
  })
}

// 删除教师加班
export function delTeacherOvertime(ids) {
  return request({
    url: '/school/teacherOvertime/delete/' + ids,
    method: 'delete'
  })
}

// 提交申请
export function submitApply(id) {
  return request({
    url: '/school/teacherOvertime/submitApply/' + id,
    method: 'post',
  })
}


/**
 * 待办事项列表
 */
export function taskList(query) {
  return request({
    url: '/school/teacherOvertime/taskList',
    method: 'get',
    params: query
  })
}

/**
 * 已办项列表
 */
export function taskDoneList(query) {
  return request({
    url: '/school/teacherOvertime/taskDoneList',
    method: 'get',
    params: query
  })
}

//审批历史列表
export function listHistory(data) {
  return request({
    url: '/activiti/process/listHistory',
    method: 'get',
    params: data
  })
}

// 进度查看
export function viewSchedule(data) {
  return request({
    url: '/activiti/process/read-resource',
    method: 'get',
    params: data
  })
}


/** 审批任务 */
export function complete({taskId, instanceId, comment, pass}) {
  return request({
    url: `/school/teacherOvertime/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}

/** 销假 */
export function cancelLeave(taskId, postForm) {
  return request({
    url: '/school/teacherOvertime/cancelLeave/' + taskId,
    method: 'post',
    data: postForm
  })
}
