import request from '@/utils/request'

// 查询学生关键信息变更列表
export function listChange(query) {
  return request({
    url: '/studentChange/list',
    method: 'get',
    params: query
  })
}


// 查询学生信息列表
export function listStudent(query) {
  return request({
    url: '/school/student/list',
    method: 'get',
    params: query
  })
}

// 查询学生关键信息变更详细
export function getChange(id) {
  return request({
    url: '/studentChange/queryById/' + id,
    method: 'get'
  })
}

// 新增学生关键信息变更
export function addChange(data) {
  return request({
    url: '/studentChange/add',
    method: 'post',
    data: data
  })
}

// 修改学生关键信息变更
export function updateChange(data) {
  return request({
    url: '/studentChange/edit',
    method: 'put',
    data: data
  })
}

// 删除学生关键信息变更
export function delChange(ids) {
  return request({
    url: `/studentChange/delete/${ids}`,
    method: 'delete'
  })
}

// 提交学生关键信息变更
export function submit(ids) {
  return request({
    url: `/studentChange/submit/${ids}`,
    method: 'put'
  })
}
// 文件上传方法
export function commonUpload(file, callback = null) {
  return request({
    url: '/common/upload',
    method: 'post',
    data: file,
    onUploadProgress: progress => {
      callback && callback(progress)
    }
  })
}
