import request from '@/utils/request'



// 查询学生德育列表
export function listEducation(queryParams, ruleId) {
  return request({
    // url: `/school/educationRuleDetails/list/${ ruleId }`,
    // url: `/school/educationDetails/list/${ ruleId }`,
    url: `/school/educationDetails/list`,
    method: 'get',
    params: queryParams
  })
}

// 提交得分
export function updateScore({ score, ruleId, ids }) {
  console.log({ ruleId, ids })
  return request({
    url: '/studentmanage/check/' + ids,
    method: 'post',
    params: {
      score,
      ruleId
    },
    data: {
      ids: [...ids]
    }
  })
}
// 新增打分规则(打分时，新增打分规则)
export function addByPatrolId(patrolId, ruleId) {
  return request({
    url: `/schoolPatrolDetails/addRuleDetails/${ patrolId }/${ ruleId }`,
    method: 'post'
  })
}




// 查询学生德育规则明细列表
// export function listEducation(query) {
//   return request({
//     url: '/school/educationRuleDetails/list',
//     method: 'get',
//     params:query
//   })
// }

// 查询学生德育规则明细
export function getEducation(id) {
  return request({
    url: '/school/educationRuleDetails/queryOne/' + id,
    method: 'get'
  })
}

// 新增学生德育规则明细
export function addEducation(data) {
  return request({
    url: '/school/educationRuleDetails/add/' + data.ruleId,
    method: 'post',
    data: data
  })
}

// 修改学生德育规则明细
export function updateEducation(data) {
  return request({
    url: '/school/educationRuleDetails/edit',
    method: 'put',
    data: data
  })
}

// 删除学生德育规则明细
export function delEducation(ids) {
  return request({
    url: '/school/educationRuleDetails/delete/' + ids,
    method: 'delete'
  })
}
