import request from "@/utils/request";

/**
 * @description 学校资源文档信息
 * */

// 列表查询
export function getList(queryForm) {
  return request({
    url: '/schoolResourcesDetails/list',
    method: 'get',
    params: queryForm
  })
}

// 获取学校资源库详细信息
export function getInfo(id) {
  return request({
    url: '/schoolResourcesDetails/getInfo/' + id,
    method: 'get'
  })
}

// 新增学校资源库详细信息
export function addResourceDetail(postForm) {
  return request({
    url: '/schoolResourcesDetails/add',
    method: 'post',
    data: postForm
  })
}

// 修改学校资源库详细信息
export function editResourceDetail(postForm) {
  return request({
    url: '/schoolResourcesDetails/edit',
    method: 'put',
    data: postForm
  })
}

// 删除学校资源库详细信息
export function deleteResourceDetail(ids) {
  return request({
    url: '/schoolResourcesDetails/delete/' + ids,
    method: 'delete',
  })
}

// 点赞
export function updateThumbsUp(id) {
  return request({
    url: '/schoolResourcesDetails/updateThumbsUp/' + id,
    method: 'get'
  })
}

// 收藏
export function updateCollection(id) {
  return request({
    url: '/schoolResourcesDetails/updateCollection/' + id,
    method: 'get'
  })
}

// 下载
export function updateDownload(id) {
  return request({
    url: '/schoolResourcesDetails/updateDownload/' + id,
    method: 'get'
  })
}
