import request from "@/utils/request";
//查询产品分类列表
export function getProduct(query) {
  return request({
    url: "/productCategory/list",
    method: "get",
    params: query,
  });
}
//查看产品分类详细信息
export function queryProduct(id) {
  return request({
    url: "/productCategory/" + id,
    method: "get",
  });
}
//新增产品分类
export function addProduct(data) {
  return request({
    url: "/productCategory/add",
    method: "post",
    data,
  });
}
//修改产品分类信息
export function editProduct(data) {
  return request({
    url: "/productCategory/edit",
    method: "put",
    data: data,
  });
}
//删除产品分类信息;
export function deleteProduct(id) {
  return request({
    url: "/productCategory/delete/" + id,
    method: "post",
  });
}
//获取设备分类下拉框
export function getProductCategory(query) {
  return request({
    url: "/productCategory/getEquipmentType",
    method: "get",
    params: query,
  });
}
//获取管理员
export function getAdmin(query) {
  return request({
    url: "/productCategory/getAdmin",
    method: "get",
    params: query,
  });
}
