import request from "@/utils/request"

/**
 * @description 学校时刻明细 接口
 */

// 列表查询
export function getDetailList(queryForm, schoolTimeId) {
  return request({
    url: '/schoolTimeDetail/list/' + schoolTimeId,
    method: 'get',
    params: queryForm
  })
}

// 新增
export function addTimeDetail(postForm, schoolTimeId) {
  return request({
    url: '/schoolTimeDetail/add/' + schoolTimeId,
    method: 'post',
    data: postForm
  })
}

// 修改
export function editTimeDetail(postForm) {
  return request({
    url: '/schoolTimeDetail/edit',
    method: 'put',
    data: postForm
  })
}

// 删除
export function deleteTimeDetail(ids) {
  return request({
    url: '/schoolTimeDetail/delete/' + ids,
    method: 'delete',
  })
}

// 查询详情
export function queryOneDetail(id) {
  return request({
    url: '/schoolTimeDetail/queryOne/' + id,
    method: 'get'
  })
}
