import request from "@/utils/request";

/**
 * @description 学校时刻 接口
 * */

// 列表查询
export function getList(queryForm) {
  return request({
    url: '/schoolTime/list',
    method: 'get',
    params: queryForm
  })
}

// 新增
export function addSchoolTime(postForm) {
  return request({
    url: '/schoolTime/add',
    method: 'post',
    data: postForm
  })
}

// 修改
export function editSchoolTime(postForm) {
  return request({
    url: '/schoolTime/edit',
    method: 'put',
    data: postForm
  })
}

// 查询详情
export function getDetail(id) {
  return request({
    url: '/schoolTime/queryOne/' + id,
    method: 'get'
  })
}

// 删除
export function deleteSelect(ids) {
  return request({
    url: '/schoolTime/delete/' + ids,
    method: 'delete'
  })
}

// 修改状态
export function changeUserStatus(id, state) {
  return request({
    url: '/schoolTime/changeIsUsed/' + id,
    method: 'put',
    params: {
      state,
      id
    }
  })
}
