import request from '@/utils/request'

// 查询园区照片列表
export function listPic(query) {
  return request({
    url: 'pic/list',
    method: 'get',
    params: query
  })
}

// 查询园区照片详细
export function getPic(ids) {
  return request({
    url: '/pic/' + ids,
    method: 'get'
  })
}

// 新增园区照片
export function addPic(data) {
  return request({
    url: '/pic/add',
    method: 'post',
    data: data
  })
}

// 修改园区照片
export function updatePic(data) {
  return request({
    url: '/pic/edit',
    method: 'put',
    data: data
  })
}

// 删除园区照片
export function delPic(ids) {
  return request({
    url: '/pic/delete/' + ids,
    method: 'delete'
  })
}

// 设置/取消 为轮播
export function updateState(id, isShow) {
  return request({
    url: '/pic/updateState/' + id,
    method: 'get',
    params: {
      state: isShow
    }
  })
}
