import request from "@/utils/request";

// 新增培训情况
export function addTraining(data) {
  return request({
    url: "/training/add",
    method: "post",
    data: data,
  });
}
//修改培训情况
export function updateTraining(data) {
  return request({
    url: "/training",
    method: "put",
    data: data,
  });
}
// 查询培训情况列表
export function getTraining(query) {
  return request({
    url: "/training/list",
    method: "get",
    params: query,
  });
}

// 查询培训情况详情
export function listTraining(ids) {
  return request({
    url: "/training/" + ids,
    method: "get",
  });
}

// 删除培训情况
export function delTraining(ids) {
  return request({
    url: "/training/" + ids,
    method: "delete",
  });
}
