import request from '@/utils/request'

// 查询老师请假信息列表
export function listTeacherLeave(query) {
  return request({
    url: '/school/teacherLeave/list',
    method: 'get',
    params: query
  })
}

// 查询老师请假信息详细
export function getTeacherLeave(id) {
  return request({
    url: '/school/teacherLeave/queryOne/' + id,
    method: 'get'
  })
}

// 新增老师请假信息
export function addTeacherLeave(data) {
  return request({
    url: '/school/teacherLeave/add',
    method: 'post',
    data: data
  })
}

// 修改老师请假信息
export function updateTeacherLeave(data) {
  return request({
    url: '/school/teacherLeave/edit',
    method: 'put',
    data: data
  })
}

// 删除老师请假信息
export function delTeacherLeave(ids) {
  return request({
    url: '/school/teacherLeave/delete/' + ids,
    method: 'delete'
  })
}

//提交申请
export function submitApply(id) {
  return request({
    url: '/school/teacherLeave/submitApply/' + id,
    method: 'post',
  })
}


/**
 * 待办事项列表
 */
export function taskList(query) {
  return request({
    url: '/school/teacherLeave/taskList',
    method: 'get',
    params: query
  })
}

/**
 * 我的已办列表
 */
export function taskDoneList(query) {
  return request({
    url: '/school/teacherLeave/taskDoneList',
    method: 'get',
    params: query
  })
}

//审批历史列表
export function listHistory(data) {
  return request({
    url: '/activiti/process/listHistory',
    method: 'get',
    params: data
  })
}

/** 销假列表（同历史任务接口，目前分两个接口来做） */
export function revokeList(data) {
  return request({
    url: '/activiti/process/listHistory',
    method: 'get',
    params: data
  })
}

// 进度查看
export function viewSchedule(data) {
  return request({
    url: '/activiti/process/read-resource',
    method: 'get',
    params: data
  })
}

/** 审批任务 */
export function complete({taskId, instanceId, comment, pass}) {
  return request({
    url: `/school/teacherLeave/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}

/** 销假 */
export function cancelLeave(taskId, postForm) {
  return request({
    url: '/school/teacherLeave/cancelLeave/' + taskId,
    method: 'post',
    data: postForm
  })
}

/*新增修改dialog*/

//获取级部/处室下拉框
export function getGradeOfficeList(query) {
  return request({
    url: '/schoolGrade/getList',
    method: 'get',
    params: query
  })
}

//获取级部/处室  主任  下拉框
export function getGradeOfficeDirectorList(form) {
  return request({
    url: '/school/teacherLeave/getDeptLeader/' + form.applyOrgid,
    params: form,
    method: 'get',
  })
}

//分管领导/主要领导下拉框
export function getLeaderList(form) {
  return request({
    url: '/school/teacherLeave/getSchoolLeader',
    params: form,
    method: 'get',
  })
}

//根据请假开始时间和结束时间，获取请假时长
export function getLeaveTime(data) {
  return request({
    url: '/school/teacherLeave/getTotalTime',
    method: 'get',
    params: data,
  })
}


export function getDepId() {
  return request({
    url: '/schoolGrade/getDeptOrGrade',
    method: 'get',
  })
}

