import request from "@/utils/request";
// 新增预算填报
export function adddeBudget(data) {
  return request({
    url: "/departmentBudget/add",
    method: "post",
    data: data,
  });
}
// 修改预算填报
export function editdeBudget(data) {
  return request({
    url: "/departmentBudget/edit",
    method: "put",
    data: data,
  });
}
//查看预算填报
export function queryDepart(id) {
  return request({
    url: "/departmentBudget/"+id,
    method: "get",
  });
}

//查看本单位预算填报列表;
export function getdeBudgetList(query) {
  return request({
    url: "/departmentBudget/listDw",
    method: "get",
    params: query,
  });
}


// 删除预算填报
export function deleteDepart(id) {
  return request({
    url: "/departmentBudget/" + id,
    method: "delete",
  });
}
// 提交申请
export function submitApply(id) {
  return request({
    url: "/departmentBudget/submitApply/" + id,
    method: "post",
  });
}
// 获取登录人信息
export function departUser() {
  return request({
    url: "/departmentBudget/getUserXx",
    method: "get",
  });
}