import request from '@/utils/request'


// 新增物品登记
export function addAssets(data) {
  return request({
    url: '/schoolAssetsClaim/add',
    method: 'post',
    data: data
  })
}

// 修改物品登记
export function updateAssets(data) {
  return request({
    url: '/schoolAssetsClaim/edit',
    method: 'post',
    data: data
  })
}


export function listAssets(data) {
  return request({
    url: '/schoolAssetsClaim/list',
    method: 'get',
    params: data
  })
}

// 提交物品登记
export function submitAssets(id) {
  return request({
    url: '/schoolAssetsClaim/submit/' + id,
    method: 'post',
  })
}

export function delAssets(ids) {
  return request({
    url: '/schoolAssetsClaim/deleteById/' + ids,
    method: 'delete'
  })
}

export {listAssets as addAssetsTableInfo} from "@/api/smartSchool/logisticsManage/itemRegistration.js"


/*资产归属*/
export function listInform2(data) {
  return request({
    url: '/school/teacher/teacherList',
    method: 'get',
    params: data
  })
}

export function listInform() {
  return request({
    url: '/school/teacher/getTeachers',
    method: 'get'
  })
}


//获取部门树
export function getDeptTree() {
  return request({
    url: '/system/user/deptTree',
    method: 'get'
  })
}

//获取资产列表
export function listAssests(data) {
  return request({
    url: '/schoolAssets/list',
    method: 'get',
    params: data
  })
}

export function teacherListInform(data){
  return request({
    url: '/school/teacher/getTeacherList',
    method: 'get',
    params: data
  })
}
