import request from "@/utils/request";

/**
 * @description 学校消息推送详情
 * */

// 查询消息推送详情列表
export function getList(pushId, queryForm = null) {
  return request({
    url: 'schoolMessagePushDetails/list/' + pushId,
    method: 'get',
    params: queryForm
  })
}

// 新增,挂载到当前的消息通知下
export function addReceive(puhsId, ids) {
  return request({
    url: `schoolMessagePushDetails/add/${ pushId }/${ ids }`,
    method: 'post'
  })
}

// 删除
export function deleteReceive(puhsId, ids) {
  return request({
    url: `schoolMessagePushDetails/delete/${ pushId }/${ ids }`,
    method: 'delete'
  })
}
