import request from "@/utils/request";

export function getList(queryParams, stateId) {
  return request({
    url: "/epidemicMain/list",
    method: 'get',
    params: { ...queryParams, state: stateId }
  })
}

export function addToList(reqFormData) {
  return request({
    url: "/epidemicMain/add",
    method: 'post',
    data: reqFormData
  })
}

export function editOnList(reqFormData) {
  return request({
    url: "/epidemicMain/edit",
    method: 'put',
    data: reqFormData
  })
}

export function deleteData(ids) {
  return request({
    url: `/epidemicMain/delete/${ ids }`,
    method: 'delete',
  })
}

export function publishExam(id) {
  return request({
    url: `/epidemicMain/publishExam/${ id }`,
    method: 'get',
  })
}

export function recallExam(id) {
  return request({
    url: `/epidemicMain/recallExam/${ id }`,
    method: 'get',
  })
}

export function finishExam(id) {
  return request({
    url: `/epidemicMain/finishExam/${ id }`,
    method: 'get',
  })
}

export class BackToFrontTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.activityTitle = data.examName
    this.note = data.remark
    this.status = data.state
    this.startTime = data.startTime
    this.endTime = data.endTime
    ///关键部分结束///
    this.optionScope = data.optionScope
    this.isLeaderExam = data.isLeaderExam
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.examName = data.activityTitle
    this.remark = data.note
    this.state = data.status
    this.startTime = data.startTime
    this.endTime = data.endTime
    ///关键部分结束///
    this.optionScope = data.optionScope
    this.isLeaderExam = data.isLeaderExam
  }
}
