import request from '@/utils/request'

// 查询设备领用列表
export function listClaim(query) {
  return request({
    url: '/deviceClaim/list',
    method: 'get',
    params: query
  })
}

// 查询设备领用详细
export function getClaim(id) {
  return request({
    url: `/deviceClaim/queryById/${id}`,
    method: 'get'
  })
}

// 新增设备领用
export function addClaim(data) {
  return request({
    url: '/deviceClaim/add',
    method: 'post',
    data: data
  })
}

// 提交设备领用申请
export function submitApplyClaim(id) {
  return request({
    url: `/deviceClaim/submitApply/${id}`,
    method: 'post',
  })
}

// 修改设备领用
export function updateClaim(data) {
  return request({
    url: `/deviceClaim/edit`,
    method: 'put',
    data: data
  })
}

// 删除设备领用
export function delClaim(id) {
  return request({
    url: `/deviceClaim/deleteByIds/${id}`,
    method: 'delete'
  })
}

// 查询设备审批历史
export function getApprovalHistory(query) {
  return request({
    url: '/activiti/process/listHistory',
    method: 'get',
    params: query
  })
}

// 查询进度
export function getProcess(query) {
  return request({
    url: '/activiti/process/read-resource',
    method: 'get',
    params: query

  })
}

// 待办请求
// 查询待办列表
export function taskList(query) {
  return request({
    url: '/deviceClaim/taskList',
    method: 'get',
    params: query
  })
}

// 查询已办列表
export function taskDoneList(query) {
  return request({
    url: '/deviceClaim/taskDoneList',
    method: 'get',
    params: query
  })
}


// 我的代办任务
export function myTaskList(query) {
  return request({
    url: '/deviceClaim/myTaskList',
    method: 'get',
    params: query
  })
}

// 处理任务
export function complete({taskId, instanceId, comment, pass}) {
  return request({
    url: `/deviceClaim/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}


