import request from '@/utils/request'

// 查询课堂巡视打分明细列表
export function listDetailes(queryParams, rulrId) {
  return request({
    url: `/schoolPatrolRuleDetails/list/${rulrId}`,
    method: 'get',
    params: queryParams
  })
}

// 查询课堂巡视打分明细详细
// export function getDetailes(id) {
//   return request({
//     url: '/schoolPatrolRuleDetails/list/' + id,
//     method: 'get'
//   })
// }

// // 新增课堂巡视打分明细
export function addDetailes(reqFormData,rulrId) {
  return request({
    url: `/schoolPatrolRuleDetails/add/${rulrId}`,
    method: 'post',
    data: reqFormData
  })
}

// // 修改课堂巡视打分明细
export function updateDetailes(reqFormData, rulrId) {
  return request({
    url: `/schoolPatrolRuleDetails/edit/${rulrId}`,
    method: 'put',
    data: reqFormData
  })
}

// // 删除课堂巡视打分明细
export function delDetailes(ids) {
  return request({
    url: `/schoolPatrolRuleDetails/delete/${ids}`,
    method: 'delete'
  })
}

// //导出表格选中行数据
// export function exportPart(ids) {
//   return request({
//     url: '/schoolPatrolRuleDetails/export' + ids,
//     method: 'post',
//     data: ids
//   })
// }

// //导出表格所有数据
// export function exportFull() {
//   return request({
//     url: '/schoolPatrolRuleDetails/export',
//     method: 'post',
//   })
// }

export class FrontToBackTransfer {
  constructor(data) {
    this.rulrId = data.rulrId
    this.id = data.id
    this.content = data.content
    this.score = data.score
    this.sort = data.sort
  }
}