import request from '@/utils/request'

// 查询课堂巡视列表
export function listPatrol(query) {
  return request({
    url: '/schoolPatrol/list',
    method: 'get',
    params: query
  })
}

// 查询课堂巡视详细
// export function getPatrol(id) {
//   return request({
//     url: '/schoolPatrol/patrol/' + id,
//     method: 'get'
//   })
// }

// 新增课堂巡视
export function addPatrol(data) {
  return request({
    url: '/schoolPatrol/add',
    method: 'post',
    data: data
  })
}

// 修改课堂巡视
export function updatePatrol(reqFormData) {
  return request({
    url: '/schoolPatrol/edit',
    method: 'put',
    data: reqFormData
  })
}

// 删除课堂巡视
export function delPatrol(ids) {
  return request({
    url: '/schoolPatrol/delete/' + ids,
    method: 'delete',
    // data: ids
  })
}


//导出表格选中行数据
export function exportPart(ids) {
  return request({
    url: '/schoolPatrol/export/' + ids,
    method: 'post',
    data: ids
  })
}

//导出表格所有数据
export function exportFull() {
  return request({
    url: '/schoolPatrol/export',
    method: 'post',
  })
}

//新增打分明细表数据
export function addDetailess(id) {
  return request({
    url: '/schoolPatrol/addDetails' + id,
    method: 'post',
  })
}

// 查询课堂巡视详细得分列表
// export function listDetailess(patrolId) {
//   return request({
//     url: '/schoolPatrolDetails/list/' + patrolId,
//     method: 'get',
//   })
// }

// 查询班级列表
export function addList(queryParams) {
  return request({
    url: '/schoolGrade/list',
    method: 'get',
    params: queryParams
  })
}
// 查询用户列表
export function listUser(query) {
  return request({
    url: '/system/user/list',
    method: 'get',
    params: query
  })
}