import request from '@/utils/request'

// 查询课堂巡视详细得分列表
export function listDetailess(queryParams, patrolId) {
  return request({
    url: `/schoolPatrolDetails/list/${ patrolId }`,
    method: 'get',
    params: queryParams
  })
}

// 提交得分
export function updateScore({ score, patrolId, ids }) {
  console.log({ patrolId, ids })
  return request({
    url: '/schoolPatrolDetails/score/' + ids,
    method: 'post',
    params: {
      score,
      patrolId
    },
    data: {
      ids: [...ids]
    }
  })
}


// // // 查询课堂巡视详细得分详细
// export function getDetailess(patrolId) {
//   return request({
//     url: '/schoolPatrolDetails/detailess/' + patrolId,
//     method: 'get'
//   })
// }

// // 新增课堂巡视详细得分
// export function addDetailess(data) {
//   return request({
//     url: '/schoolPatrolDetails/detailess',
//     method: 'post',
//     data: data
//   })
// }

// // 修改课堂巡视详细得分
// export function updateDetailess(data) {
//   return request({
//     url: '/schoolPatrolDetails/detailess',
//     method: 'put',
//     data: data
//   })
// }

// // 删除课堂巡视详细得分
// export function delDetailess(id) {
//   return request({
//     url: '/schoolPatrolDetails/detailess/' + id,
//     method: 'delete'
//   })
// }


// 新增打分规则(打分时，新增打分规则)
export function addByPatrolId(patrolId, ruleId) {
  return request({
    url: `/schoolPatrolDetails/addRuleDetails/${ patrolId }/${ ruleId }`,
    method: 'post'
  })
}
