import request from '@/utils/request'


//查询年级
export function listGrade(){
  return request({
    url:'schoolGrade/getGradeForSelecter',
    method:'get'
  })
}
//根据年级id查询班级
export function listClass(id){
 return request({
   url:'schoolGrade/getClassForSelecter/'+id,
   method:'get'
 })
}

// 查询场地详情信息列表
export function listAreadetail(query) {
  return request({
    url: '/areaDetail/list',
    method: 'get',
    params: query
  })
}

// 查询场地详情信息详细
export function getAreadetail(id) {
  return request({
    url: '/areaDetail/queryById/' + id,
    method: 'get'
  })
}

// 根据areaId查询场地详情信息详细
export function getAreadetailByAreaId(id) {
  return request({
    url: '/areaDetail/queryByAreaId/' + id,
    method: 'get'
  })
}


// 新增场地详情信息
export function addAreadetail(data) {
  return request({
    url: '/areaDetail/add',
    method: 'post',
    data: data
  })
}

// 修改场地详情信息
export function updateAreadetail(data) {
  return request({
    url: '/areaDetail/edit',
    method: 'put',
    data: data
  })
}

// 删除场地详情信息
export function delAreadetail(id) {
  return request({
    url: '/areaDetail/delete/' + id,
    method: 'delete'
  })
}
