import request from '@/utils/request'

// 查询场地信息列表
export function listArea(areaName) {
  return request({
    url: '/area/list',
    method: 'get',
    params: areaName
  })
}

// 查询场地信息详细
export function getArea(id) {
  return request({
    url: '/area/queryById/' + id,
    method: 'get'
  })
}

// 新增场地信息
export function addArea(data) {
  return request({
    url: '/area/add',
    method: 'post',
    data: data
  })
}

// 修改场地信息
export function updateArea(data) {
  return request({
    url: '/area/edit',
    method: 'put',
    data: data
  })
}

// 删除场地信息
export function delArea(id) {
  return request({
    url: '/area/delete/' + id,
    method: 'delete'
  })
}

//导出表格所有数据
export function exportFull() {
  return request({
    url: '/area/export',
    method: 'post',
  })
}
