package com.ruoyi.common.utils;

import net.sf.sevenzipjbinding.*;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;

import javax.imageio.IIOException;
import java.io.*;
import java.util.Arrays;

public class OtherPackeUtil {
    public static  void decompressFile (File file, final String targetFileDir) throws IOException {
        //解压7zip文件
        RandomAccessFile randomAccessFile = null ;
        IInArchive inArchive = null;
        try {
            //判断目标目录是否存在，不存在则创建
            File newdir = new File (targetFileDir) ;
            if (false == newdir. exists()) {
                newdir. mkdirs() ;
                newdir = null ;
            }
            randomAccessFile = new RandomAccessFile(file,"r");
            RandomAccessFileInStream t = new RandomAccessFileInStream(randomAccessFile);
            if(file.getName().endsWith("rar")){
                inArchive = SevenZip.openInArchive(ArchiveFormat.RAR5, t);
            }
            else if(file.getName().endsWith("7z")){
                inArchive = SevenZip.openInArchive(ArchiveFormat.SEVEN_ZIP, t);
            }
            else{
                inArchive = SevenZip.openInArchive(ArchiveFormat.ZIP, t);
            }
            ISimpleInArchive simpleInArchive=inArchive.getSimpleInterface();
            for(final ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()){
                final int[] hash = new int[]{0};
                if(!item.isFolder()){
                    ExtractOperationResult result;
                    final long[] sizeArray =new long[1];
                    result = item.extractSlow(new ISequentialOutStream() {
                        @Override
                        public int write(byte[] data) throws SevenZipException {
                            //写入指定文件
                            FileOutputStream fos;
                            try {
                                if(item.getPath().indexOf(File.separator)>0){
                                    String path = targetFileDir + File.separator +item.getPath().substring(0,item.getPath().lastIndexOf(File.separator));
                                    File folderExisting = new File(path);
                                    if(!folderExisting.exists()){
                                        new File(path).mkdirs();
                                    }
                                }
                                fos = new FileOutputStream(targetFileDir +File.separator + item.getPath(),true);
                                fos.write(data);
                                fos.close();
                            }catch (Exception e){
                                   e.printStackTrace();
                            }
                            hash[0] = Arrays.hashCode(data);
                            sizeArray[0] +=data.length;
                            return data.length;
                        }
                    });
                    if(result == ExtractOperationResult.OK){
                        System.out.println(String.format("%9X|%10X|%s",hash[0],sizeArray[0],item.getPath()));
                    }
                    else{
                        System.err.println("Error extracting item:" + result);
                    }
                }

            }

        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }finally {
            if(inArchive != null){
               try {
                  inArchive.close();
               }catch (SevenZipException e){
                   System.out.println("Error closing archive:" + e);
               }
            }
            if(randomAccessFile != null){
                try{
                    randomAccessFile.close();
                }catch (IIOException e){
                    System.out.println("Error closing file:" + e);
                }
            }
        }
    }
}
