package com.core.handler;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.ruoyi.common.utils.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Date;

import static com.ruoyi.common.utils.SecurityUtils.getUsername;


@Component
public class MyMetaObjectHandler implements MetaObjectHandler {

    private Logger log = LoggerFactory.getLogger(MyMetaObjectHandler.class);

    @Override
    public void insertFill(MetaObject metaObject) {
        String userName = "";
        try {
            userName = getUsername();
        } catch (Exception e) {
            log.error("获取用户名失败");
            userName = "";
        }
        this.setFieldValByName("createBy", userName, metaObject);
        this.setFieldValByName("createTime", new Date(), metaObject);
        this.setFieldValByName("updateBy", userName,metaObject);
        this.setFieldValByName("updateTime", new Date(), metaObject);
        this.setFieldValByName("delFlag", "0", metaObject);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        String userName = "";
        try {
            userName = getUsername();
        } catch (Exception e) {
            log.error("获取用户名失败");
            userName = "";
        }
        this.setFieldValByName("updateBy", userName,metaObject);
        this.setFieldValByName("updateTime", new DateTime(), metaObject);
    }
}
