package yangtz.cs.liu.wechat.vo.purchase;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import yangtz.cs.liu.campus.domain.purchase.SchoolPurchaseDetails;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class WxPurchaseVo{
    private Long id;
    /**
     * 标题
     */
    private String purchaseName;

    /**
     * 申请部门
     */
    private Long deptId;

    /**
     * 申请部门名称
     */
    private String deptName;

    /**
     * 期望日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expectedDate;

    /**
     * 批复预算名称
     */
    private String budgetName;

    /**
     * 批复预算ID
     */
    private Long budgetId;

    /**
     * 采购金额
     */
    private BigDecimal purchaseMoney;

    /**
     * 采购说明
     */
    private String remark;

    /**
     * 审批人id1
     */
    private Long handUserId1;

    /**
     * 审批人名字1
     */
    private String handUserName1;

    /**
     * 审批人id2
     */
    private Long handUserId2;

    /**
     * 审批人名字2
     */
    private String handUserName2;

    /**
     * 申请人id
     */
    private Long applyId;

    /**
     * 申请人姓名
     */
    private String applyUser;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 流程实例ID
     */
    private String instanceId;

    /**
     * 状态
     */
    private String state;

    /**子表数据*/
    List<SchoolPurchaseDetails> list;
}
