package yangtz.cs.liu.wechat.vo.message;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
@Data
public class ParentPushVO {
    //信息id
    private Long id;

    /** 标题 */
    private String title;

    /** 消息类型 */
    private String messageType;

    /** 状态 0=正常,1=停用 */
    private String state;

    /** 内容 */
    private String content;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /** 用户阅读状态 0未读 1已读 */
    private String status;
}
