package yangtz.cs.liu.wechat.vo.attendance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAttendance;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class TeacherAttendanceVO {


    /**
     * 老师id
     */
    @NotNull(message = "教师id不能为空")
    private Long teacherId;

    /** 微信openid*/
    @NotBlank(message = "微信openid不能为空")
    private String openId;

    /*
    * 用户id
    * */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 出勤年月  例如：2022-10  查询年就传2022-0  查询月就传2022-10 查询当月就传 0
     */
    @NotBlank(message = "出勤年月不能为空")
    private String researchTime;

    /*
    * 出勤天数
    * */
    private int attendanceDays;

    /*
    * 未出勤天数
    * */
    private int unAttendanceDays;


    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

//    当天考勤的记录
    private SchoolTeacherAttendance schoolTeacherAttendance;
}
