package yangtz.cs.liu.wechat.utils;


import java.util.Date;

public class TimestampUtil {

  /**
   * 验证时间戳是否合法
   * @param cacheKey
   * @param currentTimestamp
   * @return
   */
  public static Boolean validateTimestamp(String cacheKey,long currentTimestamp) {
    long beforeTimeStamp = 0;

    // //当前时间戳小于或等于之前的时间戳。说明是重复的
    if(currentTimestamp < beforeTimeStamp && beforeTimeStamp > 0) {
      return false;
    }
    //session可能会超时
    long nowTimeStamp = getSecondTimestampTwo(new Date());
    if(nowTimeStamp - currentTimestamp > 3000000) {
      return false;
    }
    return true;

  }

  /**
   * 精确到秒的时间戳
   * @param date
   * @return
   */
  private static long getSecondTimestampTwo(Date date) {
    if(null == date) {
      return 0;
    }
    String timestamp = String.valueOf(date.getTime()/1000);
    return Long.parseLong(timestamp);
  }

}