package yangtz.cs.liu.wechat.domain.template;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
public class StudentLeaveTemplate {
    private String first;

    /** 请假原因 */
    private String reasonForLeave;

    /** 请假类型 */
    private String type;

    /**
     * 目标客户
     */
    private String toUserOpenId;

    /**
     * 学生姓名
     */
    private String studentName;

    /**
     * 班级
     */
    private String className;

    /**
     * 请假开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date leaveStartTime;

    /**
     * 请假结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date leaveEndTime;
}
