package yangtz.cs.liu.wechat.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lyric
 * @date 2022/11/7 20:21
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class WXMessgeBean {

    private int ArticleCount;

    private ArticleMessage Articles;


    public int getArticleCount() {
        return ArticleCount;
    }

    public void setArticleCount(int articleCount) {
        ArticleCount = articleCount;
    }

    public ArticleMessage getArticles() {
        return Articles;
    }

    public void setArticles(ArticleMessage articles) {
        Articles = articles;
    }

    //新增图文消息Bean
    public static class ArticleMessage {
        private List<ArticleItem> item;

        @XmlElement(name = "item")
        public List<ArticleItem> getItem() {
            if (item == null)
                item = new ArrayList<>();
            return item;
        }
    }

    public static class ArticleItem {
        private String title;
        private String description;
        private String picUrl;
        private String url;

        public String getTitle() {
            return title;
        }

        @XmlElement(name = "Title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return description;
        }

        @XmlElement(name = "Description")
        public void setDescription(String description) {
            this.description = description;
        }

        public String getPicUrl() {
            return picUrl;
        }

        @XmlElement(name = "PicUrl")
        public void setPicUrl(String picUrl) {
            this.picUrl = picUrl;
        }

        public String getUrl() {
            return url;
        }

        @XmlElement(name = "Url")
        public void setUrl(String url) {
            this.url = url;
        }
    }
}
