package yangtz.cs.liu.wechat.controller.timetable;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.time.*;
import yangtz.cs.liu.campus.service.time.ISchoolTimeDetailService;
import yangtz.cs.liu.campus.service.time.ISchoolTimeService;
import yangtz.cs.liu.campus.service.time.ISchoolTimeTableService;
import yangtz.cs.liu.campus.vo.time.SchoolTimeDetailVO;
import yangtz.cs.liu.campus.vo.time.TableVO;
import yangtz.cs.liu.wechat.vo.schoolTime.SchoolTimeTableVo;

import javax.swing.text.TabableView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;

import static yangtz.cs.liu.campus.constant.EmployeeType.EMPLOYEE;

@RestController
@RequestMapping("/wx/timeTable")
public class WxSchoolTimeTableController extends BaseController {

    @Autowired
    private ISchoolTimeTableService schoolTimeTableService;

    @Autowired
    private ISysUserService userService;

    @Autowired
    private ISchoolTimeService schoolTimeService;

    @Autowired
    private ISchoolTimeDetailService schoolTimeDetailService;
    @Autowired
    ISysDeptService deptService;
    /**
     * 获取家长端学生个人课表
     */
    @GetMapping("/getStudentTable/{studentId}/{classId}/{termId}")
    public TableDataInfo getStudentTable(@PathVariable("studentId") Long studentId,
                                         @PathVariable("classId") Long classId,
                                         @PathVariable("termId") int termId) {
        List<TableVO> list = schoolTimeTableService.getStudentTable(studentId,classId,termId);
        return getDataTable(list);
    }

    /**
     * 获取教师端 教师个人个人工作课表
     */
    @GetMapping("/getTeacherTable/{userId}")
    public TableDataInfo getTeacherTable(@PathVariable Long userId) {
        Long teacherId = userId;
        Boolean flag= false;
        //获取当前登录用户
        SysUser user = userService.selectUserById(teacherId);
        //判断当前所在部门是级部还是科室
        //找到当前人所有的部门跟主部门
         //1.判断主部门
        String[] split = user.getDept().getAncestors().split(",");
        if (split.length ==2){
            //当前是跟部门判断是不是级部
            if (user.getDept().getDeptName().contains("级部")){
                flag = true;
            }
        }else {
            //子部门就找主部门
            SysDept sysDept = deptService.selectDeptById(Long.valueOf(split[2]));
            if (sysDept.getDeptName().contains("级部")){
                flag = true;
            }
        }
       //2 多个部门下进行判断
        List<SysDept> sysDepts = deptService.selectConformDept(userId);
        for (SysDept dept : sysDepts){
            String[] split1 = dept.getAncestors().split(",");
            if (split1.length >= 3){
                SysDept sysDept = deptService.selectDeptById(Long.valueOf(split1[2]));
                if (sysDept.getDeptName().contains("级部")){
                    flag = true;
                    break;
                }
            }
        }
        if (!flag) {
            //throw new ServiceException("您的用户类型为职工，无法查询个人课表");
            return getDataTable(new ArrayList<>());
        }
        List<TableVO> list = schoolTimeTableService.getTeacherTable(teacherId);
        return getDataTable(list);
    }

    /**
     * 教职工课程表
     * 所在班级
     * 上下学期
     * */
    @GetMapping("/getTable/{classId}/{termId}")
    public TableDataInfo getTeacherTable(@PathVariable("classId") Long classId,
                                         @PathVariable("termId")int termId) {
        SchoolTimeTable schoolTimeTable = new SchoolTimeTable();
        schoolTimeTable.setClassId(classId);
        schoolTimeTable.setTermId(termId);
        List<TableVO> list = schoolTimeTableService.selectSchoolSchedule(schoolTimeTable);
        return getDataTable(list);
    }


    /**
     * 获取课程表
     * @param schoolTimeTableVo
     * @return
     */
    @GetMapping("/getSchoolSchedule")
    public TableDataInfo getSchoolSchedule(SchoolTimeTableVo schoolTimeTableVo) {
        startPage();
        List<SchoolTimeTableVo> schoolTimeTableVoList = schoolTimeTableService.getSchoolSchedule(schoolTimeTableVo);
        return getDataTable(schoolTimeTableVoList);
    }

    /**
     * 获取课程表
     * @return
     */
    @GetMapping("/getCourseSchedule/{studentId}")
    public AjaxResult getSchoolSchedule(@PathVariable("studentId") Long studentId) {
        if (StringUtils.isNull(studentId)) {
            return AjaxResult.error("学生id未传,请返回登录");
        }
        SchoolTimeTable schoolTimeTable = schoolTimeTableService.setGradeAndTime(studentId);
        List<SchoolCourseSchedule> list = schoolTimeTableService.getCourseSchedule(schoolTimeTable);
//        List<SchoolSchedule> list = schoolTimeTableService.selectSchoolSchedule(schoolTimeTable);
        return AjaxResult.success(list);
    }

    /**
     * 获取有效的冬夏时令
     */
    @GetMapping("/getTimeList")
    public TableDataInfo getTimeList(SchoolTime schoolTime) {
        startPage();
        List<SchoolTime> list = schoolTimeService.selectSchoolTimeList(schoolTime);
//        List<SchoolTime> schoolTimeList = list.stream().filter(u -> u.getIsUsed().equals("1")).collect(Collectors.toList());
        return getDataTable(list);
    }

    /**
     * 获取具体时令的细节
     * @param schoolTimeId 时令id
     */
    @GetMapping("/getTimeDetail/{schoolTimeId}")
    public TableDataInfo getTimeDetail(@PathVariable("schoolTimeId") Long schoolTimeId, SchoolTimeDetail schoolTimeDetail) {
        schoolTimeDetail.setSchoolTimeId(schoolTimeId);
        //startPage();
        List<SchoolTimeDetailVO> list = schoolTimeDetailService.selectSchoolTimeDetailList(schoolTimeDetail);
        return getDataTable(list);
    }


    /**
     * 获取最新学年值
     */
    @GetMapping("/getNewYear")
    public AjaxResult getNewYear() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期
        int term = 1;
        //2-7为第二学期，8-1为第一学期
        //如果当前月份小于8月，则该学年应为当前年-1 到 当前年,例如当前年月为2023年7月，则该学年为2022-2023年的第二学期
        if (month < 8) {
            nowYear = nowYear - 1;
        }
        if (month >= 2 && month < 8) {
            term = 2;
        }
        AjaxResult ajaxResult = AjaxResult.success();
        ajaxResult.put("schoolYear", nowYear);
        return ajaxResult;
    }


}
