package yangtz.cs.liu.wechat.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAward;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherAwardService;

import java.util.List;

@RestController
@RequestMapping("/wx/teacherAward")
public class WxSchoolTeacherAwardController extends BaseController {

    @Autowired
    private ISchoolTeacherAwardService schoolTeacherAwardService;

    /**
     * 获取荣誉信息
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherAward schoolTeacherAward) {
        startPage();
        List<SchoolTeacherAward> list = schoolTeacherAwardService.queryList(schoolTeacherAward);
        return getDataTable(list);
    }
}
