package yangtz.cs.liu.wechat.controller.schoolDuty;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDuty;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDutyDetails;
import yangtz.cs.liu.campus.service.schoolDuty.ISchoolDutyDetailsService;
import yangtz.cs.liu.campus.service.schoolDuty.ISchoolDutyService;

import java.util.List;

/**
 * 微信端 值班
 */
@RestController
@RequestMapping("/wx/schoolDuty")
public class WxSchoolDutyController extends BaseController {

    @Autowired
    private ISchoolDutyService schoolDutyService;

    @Autowired
    private ISchoolDutyDetailsService schoolDutyDetailsService;


    /**
     * 查询值班表列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolDuty schoolDuty)
    {
        startPage();
        List<SchoolDuty> list = schoolDutyService.queryList(schoolDuty);
        return getDataTable(list);
    }

    /**
     * 查询值班管理明细列表
     */
    @GetMapping("/list/{dutyId}")
    public TableDataInfo list(@PathVariable("dutyId") Long dutyId, SchoolDutyDetails schoolDutyDetails) {
            schoolDutyDetails.setDutyId(dutyId);
            List<SchoolDutyDetails> list = schoolDutyDetailsService.selectSchoolDutyDetailsList(schoolDutyDetails);
            return getDataTable(list);
    }

    
}
