package yangtz.cs.liu.wechat.controller.schoolCalender;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendar;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarDetailService;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 校历
 */
@RestController
@RequestMapping("/wx/calendar")
public class WxSchoolCalenderController extends BaseController {

    @Autowired
    private ISchoolCalendarService schoolCalendarService;

    @Autowired
    private ISchoolCalendarDetailService schoolCalendarDetailService;


    /**
     * 获取当前时间所在的校历
     * @param date
     * @return
     */
    @GetMapping("/getNowCalendar")
    public AjaxResult getNowCalendar(Date date){
        return AjaxResult.success(schoolCalendarService.getNowCalendar(date));
    }

    /**
     *查询当前日期所在范围内的详细条目表
     * @param
     * @return
     */
    @GetMapping(value = {"/getCalendar/{calendarId}","/getCalendar/null","/getCalendar/"})
    public TableDataInfo getCalendar(@PathVariable(value = "calendarId",required = false)Long calendarId, Date date){
       /* if(StringUtils.isNull(calendarId)){
            //说明此时没有包含当前日期的校历，，返回空列表
            return getDataTable(new ArrayList<>());
        }*/
        //startPage();
        //return getDataTable(schoolCalendarDetailService.getCalendar(date,calendarId));
        return getDataTable(schoolCalendarDetailService.selectThings(date));
    }

    /**
     * 获取当前月份所有节假日
     *
     * @param calendarId
     * @param start      头
     * @param end        尾
     * @return
     */
    @GetMapping(value = {"/getMonth/{calendarId}","/getMonth/null","/getMonth/"})
    public AjaxResult getMonth(@PathVariable(value = "calendarId",required = false) Long calendarId, Date start, Date end) {
        /*if(StringUtils.isNull(calendarId)){
            //说明此时没有包含当前日期的校历，，返回空列表
            return AjaxResult.success(new ArrayList<>());
        }*/
        return AjaxResult.success(schoolCalendarDetailService.getMonth(calendarId, start, end));
    }

}
