package yangtz.cs.liu.wechat.controller.patrol;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.framework.util.UserInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrol;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRuleDetails;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolDetailsService;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleDetailsService;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolService;
import yangtz.cs.liu.campus.vo.patrol.SchoolPatrolVo;
import yangtz.cs.liu.wechat.vo.patrol.PatrolVo;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/wx/patrol")
public class WxSchoolPatrolController extends BaseController {

    @Autowired
    private ISchoolPatrolService schoolPatrolService;

    @Autowired
    private ISchoolPatrolRuleDetailsService schoolPatrolRuleDetailsService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    @Autowired
    private ISchoolPatrolDetailsService schoolPatrolDetailsService;

    private Logger log = LoggerFactory.getLogger(WxSchoolPatrolController.class);

    /**
     *
     * @author lyric
     * @date 2022/11/20 10:39
     * 巡视列表
     */
    @GetMapping("/patrolList")
    public TableDataInfo patrolList(SchoolPatrolVo schoolPatrol) {
        try {
            startPage();
            List<SchoolPatrolVo> list = schoolPatrolService.queryList(schoolPatrol);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询课堂巡视列表异常");
        }
    }


    /**
     * 获取课堂巡视列表（老师获取自己所带班级的）
     * @param classId:老师所带班级的id
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(Long classId){
        startPage();
        List<PatrolVo> patrolList = schoolPatrolService.getPatrolList(userInfoUtil.getTeacherId(), classId);
        return getDataTable(patrolList);
    }

    /**
     * 获取课堂巡视打分详情
     * @param schoolPatrolDetails
     * @return
     */
    @GetMapping("/getDetails/{patrolId}")
    public TableDataInfo details(@PathVariable("patrolId") Long patrolId, SchoolPatrolDetails schoolPatrolDetails){
        schoolPatrolDetails.setPatrolId(patrolId);
        startPage();
        List<SchoolPatrolDetails> list = schoolPatrolDetailsService.queryList(schoolPatrolDetails);
        return getDataTable(list);
    }


}
