package yangtz.cs.liu.wechat.controller.introduce;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.file.ImageUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.introduce.SchoolPic;
import yangtz.cs.liu.campus.service.introduce.ISchoolPicService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * @author lyric
 * @date 2022/10/19 10:17
 */
@RestController
@RequestMapping("/wx/pic")
public class WxSchoolPicController extends BaseController {

    @Autowired
    private ISchoolPicService schoolPicService;
    @Value("${ruoyi.serverAddress}")
    private String serverAddress;

    @Value("${server.port}")
    private String port;
    /**
     *
     * @author lyric
     * @date 2022/10/19 15:1
     * 图片
     */
    @GetMapping("/schoolPiclist")
    public AjaxResult SchoolPiclist () {
        try {
            List<String> listUrl = new ArrayList<>();
            LambdaQueryWrapper<SchoolPic> lqw = new LambdaQueryWrapper<>();
            lqw.eq(SchoolPic::getIsShow, 1);
            List<SchoolPic> list = schoolPicService.list(lqw);
            for(SchoolPic pic : list){
                //图片路径不为空
                if(StringUtils.isNotNull(pic.getPicUrl()) && !"".equals(pic.getPicUrl())){
                    String url = pic.getPicUrl();
                    listUrl.add(url);
                }
            }
            return AjaxResult.success(listUrl);
        } catch (Exception e) {
            return AjaxResult.error();
        }
    }
}
