package yangtz.cs.liu.wechat.controller.api;


import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.redis.RedisCache;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.html.EscapeUtil;
import com.ruoyi.common.utils.http.HttpUtils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import yangtz.cs.liu.wechat.conf.AesException;
import yangtz.cs.liu.wechat.conf.SHA1;
import yangtz.cs.liu.wechat.domain.*;
import yangtz.cs.liu.wechat.domain.template.LeaveTemplate;
import yangtz.cs.liu.wechat.service.api.IWxApiService;
import yangtz.cs.liu.wechat.utils.AccessTokenUtil;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;


/**
 * @author lyric
 * @date 2022-10-15
 */
@RestController
@RequestMapping("/wx")
public class WxApiController extends BaseController {

//    @Value("${wx.token}")
//    private String token;

    @Value("${wx.appId}")
    private String appid;

    @Value("${wx.appsecret}")
    private String appsecret;

    @Value("${wx.access-token-uri}")
    private String accessTokenUri;

    @Value("${wx.menu-create-uri}")
    private String menuCreateUri;

    @Value("${wx.scope}")
    private String scope;

    @Value("${wx.redirect-uri}")
    private String redirectUri;

    @Autowired
    private RedisCache redisCache;

    @Autowired
    private AccessTokenUtil accessTokenUtil;

    @Autowired
    private IWxApiService wxApiService;

    private Logger log = LoggerFactory.getLogger(WxApiController.class);

    public static final String PERMANENT_UPLOAD_MATERIAL_URL = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=ACCESS_TOKEN&type=TYPE";

    /*
    F1FIo3icTlbxLX81Rn6NL4AEtuQhO39Txc4G3gMXMbvLggwLk0poR0RoxnW5_9-o
     */
//    @GetMapping("/test")
//    @ResponseBody
//    public AjaxResult test() {
//        try {
//            String token = accessTokenUtil.getToken();
//            String mediaId = new UploadMediaApiUtil().uploadFile(PERMANENT_UPLOAD_MATERIAL_URL, "D:\\DownLoad\\test.mp4", token, "video");
//            log.info(mediaId);
//            return AjaxResult.success(mediaId);
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            return AjaxResult.error();
//        }
//    }

    /**
     * 校验是否微信服务器消息
     *
     * @param signature
     * @param timestamp
     * @param nonce
     * @param echostr
     * @return String
     * @author lyric
     * @date 2022/10/15 13:56
     */
    @GetMapping("/wxchat")
    @ResponseBody
    public String verifyUrl(String signature, String timestamp, String nonce, String echostr) throws AesException {
        String token = "067726";
        log.info("------校验url------");
        String sha1 = SHA1.getSHA1(token, timestamp, nonce);
        if (!signature.equals(sha1)) {
            throw new AesException(AesException.ValidateSignatureError);
        }
        return echostr;
    }


    /**
     * 回复消息
     *
     * @author lyric
     * @date 2022/10/15 13:57
     */
    @PostMapping(value = "/wxchat", produces = "application/xml;charset=UTF-8")
    @ResponseBody
    public Object handleMessage(@RequestBody InMessage inMessage) throws Exception {
        log.info("----收到消息----");
        // 创建响应消息实体对象
        OutMessage outMessage = new OutMessage();
        // 把原来的接收方设置为发送方
        outMessage.setFromUserName(inMessage.getToUserName());
        // 把原来的发送方设置为接收方
        outMessage.setToUserName(inMessage.getFromUserName());
        // 设置消息类型
        outMessage.setMsgType(inMessage.getMsgType());
        // 设置消息时间
        outMessage.setCreateTime(System.currentTimeMillis());
        // 根据接收到消息类型，响应对应的消息内容
        if ("text".equals(inMessage.getMsgType())) {
            String content = inMessage.getContent();
            if (content.contains("你")) {
                outMessage.setContent("不畏将来，不念过去。如此，安好。");
            } else if (content.contains("嗨") || content.contains("嗯")) {
                outMessage.setContent("夜晚有星，云里有你，这善变的世界难得有你");
            } else if (content.contains(" ")) {
                outMessage.setContent("走的弯路很多但好在一直前进");
            } else {
                // 文本
                outMessage.setContent(content);
            }
        } else if ("image".equals(inMessage.getMsgType())) {
            // 图片
//            outMessage.setMediaId(new String[]{inMessage.getMediaId()});
        } else if (StringUtils.isNotBlank(inMessage.getEventKey())) {
            if (inMessage.getEventKey().equals("mg001")) {
                NewsMessage newsMessage = new NewsMessage();
                // 把原来的接收方设置为发送方
                newsMessage.setFromUserName(inMessage.getToUserName());
                // 把原来的发送方设置为接收方
                newsMessage.setToUserName(inMessage.getFromUserName());
                // 设置消息时间
                newsMessage.setCreateTime(System.currentTimeMillis());
                newsMessage.setArticleCount(1);
                newsMessage.setMsgType("news");

                List<Articles> list = new ArrayList<>();
                ArticleMessage articleMessage = new ArticleMessage();
                Articles articles = new Articles();
                articles.setTitle("东营市第二中学");
                articles.setDescription("东营市第二中学是东营市人民政府2000年3月批准成立的一所市直普通高级中学。学校先后荣获全国青少年校园足球特色学校、山东省依法治校先进学校、" +
                        "山东省英语特色教育重点实验学校、山东省青少年科技辅导员协会单位会员、山东省校园足球训练营、东营市规范化学校、" +
                        "东营市教学示范学校、全市教育系统先进集体、东营市五一劳动奖状、全国生命教育科研先进单位、东营市地震科普示范学校、" +
                        "市直事业单位绩效考核A级单位等30余项荣誉和称号。");
                articles.setPicUrl("http://www.dysez.net/uploads/images/20211117/76918748652c5a992f2bfb53fb3e37c8.jpg");
                articles.setUrl("http://www.dysez.net/");
                list.add(articles);

                articleMessage.setItem(list);
                newsMessage.setArticles(articleMessage);

                return newsMessage;
            } else if (inMessage.getEventKey().equals("mg002")) {
//            inMessage.getEventKey().equals("mg002")
//                "video".equals(inMessage.getMsgType())
                VideoMessage videoMessage = new VideoMessage();
                // 把原来的接收方设置为发送方
                videoMessage.setFromUserName(inMessage.getToUserName());
                // 把原来的发送方设置为接收方
                videoMessage.setToUserName(inMessage.getFromUserName());
                // 设置消息时间
                videoMessage.setCreateTime(System.currentTimeMillis());
                videoMessage.setMsgType("video");
                Video video = new Video();
//            video.setMediaId("F1FIo3icTlbxLX81Rn6NL4AEtuQhO39Txc4G3gMXMbvLggwLk0poR0RoxnW5_9-o");
//            hpeQs8SmLT2Zxuoz0jnar4diSRCjD8fmc3VyW_nbGm_ABlmSL-fx0gNKwCMPvNEGS7ChWhEX6PKP4r4BZPOKzA
//             30秒   UaGTFBxTRwp0t1WHdnelo1RISl4kerCdX0oSo3cqQK4GCNLEppClbJjENCGQ2JMs
                video.setMediaId("UaGTFBxTRwp0t1WHdnelo1RISl4kerCdX0oSo3cqQK4GCNLEppClbJjENCGQ2JMs");
//                log.info(inMessage.getMediaId());
                video.setTitle("不留遗憾,不负今生! 二中高考加油");
                video.setDescription("试纸粘墨香，金笔下千言。思虑心平定，谨慎落笔闲。且喜平常度，切忌神慌乱。畅游题海后，金榜题君名。六月高考了，祝你成功。");
                videoMessage.setVideo(video);
                return videoMessage;
            } else if (inMessage.getEventKey().equals("mg003")) {
                ImageMessage imageMessage = new ImageMessage();
                // 把原来的接收方设置为发送方
                imageMessage.setFromUserName(inMessage.getToUserName());
                // 把原来的发送方设置为接收方
                imageMessage.setToUserName(inMessage.getFromUserName());
                // 设置消息时间
                imageMessage.setCreateTime(System.currentTimeMillis());
                imageMessage.setMsgType("image");
                Image image = new Image();
                //tecHz-A4VgTukzTU0a6UN64J9a1bCeHu3v8EtuJZYio5nf9Wl4H_zVkXVk1ugw-4
                // 校徽 UaGTFBxTRwp0t1WHdnelo9ONAR1BkVpCYX7W_eMfWw4daublXgt4sxRLVMJSAbUi
                image.setMediaId("tecHz-A4VgTukzTU0a6UN64J9a1bCeHu3v8EtuJZYio5nf9Wl4H_zVkXVk1ugw-4");
                imageMessage.setImage(image);
                return imageMessage;
            } else if (inMessage.getEventKey().equals("mg004")) {
                NewsMessage newsMessage = new NewsMessage();
                // 把原来的接收方设置为发送方
                newsMessage.setFromUserName(inMessage.getToUserName());
                // 把原来的发送方设置为接收方
                newsMessage.setToUserName(inMessage.getFromUserName());
                // 设置消息时间
                newsMessage.setCreateTime(System.currentTimeMillis());
                newsMessage.setArticleCount(1);
                newsMessage.setMsgType("news");

                List<Articles> list = new ArrayList<>();
                ArticleMessage articleMessage = new ArticleMessage();
                Articles articles = new Articles();
                articles.setTitle("校长信箱");
                articles.setDescription("欢迎各位家长对市二中提出宝贵意见或建议，校长信箱：dyzzf@163.com");
                articles.setPicUrl("http://www.dysez.net/uploads/images/20211117/76918748652c5a992f2bfb53fb3e37c8.jpg");
                articles.setUrl("http://www.dysez.net/index.php/cms/lists/217.html");
                list.add(articles);

                articleMessage.setItem(list);
                newsMessage.setArticles(articleMessage);

                return newsMessage;
            } else if (inMessage.getEventKey().equals("mg005")) {
                ImageMessage imageMessage = new ImageMessage();
                // 把原来的接收方设置为发送方
                imageMessage.setFromUserName(inMessage.getToUserName());
                // 把原来的发送方设置为接收方
                imageMessage.setToUserName(inMessage.getFromUserName());
                // 设置消息时间
                imageMessage.setCreateTime(System.currentTimeMillis());
                imageMessage.setMsgType("image");
                Image image = new Image();
                image.setMediaId("tecHz-A4VgTukzTU0a6UN5GqdD3v31BoC7aR-g4UH9_vGj6McqMXTCc-SWkTY43i");
                imageMessage.setImage(image);
                return imageMessage;
            }
        } else if ("event".equals(inMessage.getMsgType())) {
            outMessage.setContent("欢迎您的到来，期盼您的支持");
        } else {
            outMessage.setContent("");
        }
        return outMessage;
    }

    /**
     * @author lyric
     * @date 2022/10/15 16:38
     * <p>
     * 获取 access_token
     * 61_SG3ERaP-X4CZO5CAt0giXX74g_LNNfVmxQccwrKUM5C0kL4yaLedoIf-b2REBB8r4u566exsY9KBkFKZ13s6vBDvVpP2oXDr84a9CvCdM8vOfzRFuuPKtfLE18VqPYyHl-lC7k9OHLqCzg7pIFAjAAALID
     */
    @GetMapping("/getAccessToken")
    @ResponseBody
    public AjaxResult getAccessToken() {
        String token = accessTokenUtil.getToken();
        return AjaxResult.success(token);
//        try {
//            String url = accessTokenUri;
//            // 利用hutool的http工具类请求获取access_token
//            String result = HttpUtil.get(url);
//            // 将结果解析为json
//            JSONObject jsonObject = JSONUtil.parseObj(result);
//            // 获取access_token
//            String accessToken = jsonObject.getStr("access_token");
//            if (!StringUtils.isEmpty(accessToken)) {
//                log.info(accessToken);
//                // 将access_token存入redis
//                redisCache.setCacheObject("access_token", accessToken,2, TimeUnit.HOURS);
//            }
//            return AjaxResult.success(accessToken);
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            return AjaxResult.error();
//        }
    }

    /*
     * 发送发膜
     * toUserOpenId 微信用户id applyTime 申请时间 remark 备注 applyUser 用户名字 content 内容 first 标题
     */
//    @GetMapping("/sendTemlp")
//    private AjaxResult sendTemlp(){
//        Map<String,Object> map = new HashMap();
//        map.put("toUserOpenId","oTrVl6iMzcAET3T-T_c3jdULe9YM");
//        map.put("applyTime","2023-05-20 15:20:30");
//        map.put("remark","测试");
//        map.put("applyUser","测试");
//        map.put("content","1111111");
//        map.put("first","测试标题");
//        VxTemlateSendApi.sendVxTemlate(map);
//        return AjaxResult.success();
//    }

    /**
     * 获取签名 noncestr timestamp signature
     * @return
     */
    @GetMapping("/getsignature")
    @ResponseBody
    public AjaxResult getsignature(String url) throws Exception {
        log.info(url);
        //获取accesToken
        url  = EscapeUtil.decode(url);
        String token = accessTokenUtil.getToken();
        //获取jsapi_ticket
        String ticket = null;
        ticket = redisCache.getCacheObject("ticket");
        if (StringUtils.isEmpty(ticket)){
            String ticketss = HttpUtils.sendGet(
                "https://api.weixin.qq.com/cgi-bin/ticket/getticket?" + "access_token=" + token
                    + "&type=jsapi");
            JSONObject jsonObject = JSONUtil.parseObj(ticketss);
             ticket = jsonObject.get("ticket").toString();
            redisCache.setCacheObject("ticket", ticket, 90, TimeUnit.MINUTES);
        }
        //生成JS-SDK权限验证的签名
        String noncester = create_nonce_str();
        String timestamp = create_timestamp();
        String string1;
        String signature = "";
        //3.
        //注意这里参数名必须全部小写，且必须有序
        string1 = "jsapi_ticket=" + ticket +
                "&noncestr=" + noncester +
                "&timestamp=" + timestamp +
                "&url=" + url;
        System.out.println(string1);
        log.info(string1);
        try
        {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e)
        {
            e.printStackTrace();
        }
        Map<String,String> map = new HashMap<String,String>();
        map.put("noncestr",noncester);
        map.put("jsapi_ticket",ticket);
        map.put("timestamp",timestamp);
        map.put("url",url);
        map.put("signature",signature);
        map.put("cstoken",token);
        return AjaxResult.success(map);


    }
    /**
     * a把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String createLinkString(Map<String, String> params) {
        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }
        return prestr;
    }
    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }
    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }
    private static String byteToHex(final byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash)
        {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }


    /**
     {
     "button": [
     {
     "type": "view",
     "name": "主页",
     "url": "https://www.baidu.com"
     },
     {
     "name": "校园生活",
     "sub_button": [
     {
     "type": "view",
     "name": "学习简介",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "校园简介",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展1",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展2",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展3",
     "url": "https://www.baidu.com"
     }
     ]
     },
     {
     "name": "校园服务",
     "sub_button": [
     {
     "type": "view",
     "name": "投稿",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "联系我们",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展1",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展2",
     "url": "https://www.baidu.com"
     },
     {
     "type": "view",
     "name": "扩展3",
     "url": "https://www.baidu.com"
     }
     ]
     }
     ]
     }

     */
    /**
     * @author lyric
     * @date 2022/10/15 17:25
     * <p>
     * 创建自定义菜单
     */
//    @GetMapping(value = "createMenu", produces = "text/html;charset=utf-8")
//    public AjaxResult createMenu() {
//        try {
//            // 从redis中取出access_token
//            String accessToken = redisCache.getCacheObject("access_token");
//            String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken;
//
//            JSONObject menu = new JSONObject();
//            JSONArray buttonAry = new JSONArray();
//
//            //一级菜单  1
//            Map<String, String> object1 = new HashMap<>();
//            object1.put("type", "view");
//            object1.put("name", "主页");
//            object1.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            //一级菜单  2
//            Map<String, String> object2 = new HashMap<>();
//            object2.put("name", "校园生活");
//            JSONArray jsonArray2 = new JSONArray();
//
//            //二级菜单  2-1
//            Map<String, String> menu2_1 = new HashMap<>();
//            object2.put("type", "view");
//            object2.put("name", "学习简介");
//            object2.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            //二级菜单 2-2
//            Map<String, String> menu2_2 = new HashMap<>();
//            object2.put("type", "view");
//            object2.put("name", "扩展2");
//            object2.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            Map<String, String> menu2_3 = new HashMap<>();
//            object2.put("type", "view");
//            object2.put("name", "扩展3");
//            object2.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            Map<String, String> menu2_4 = new HashMap<>();
//            object2.put("type", "view");
//            object2.put("name", "扩展4");
//            object2.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            Map<String, String> menu2_5 = new HashMap<>();
//            object2.put("type", "view");
//            object2.put("name", "扩展5");
//            object2.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//            jsonArray2.add(menu2_1);
//            jsonArray2.add(menu2_2);
//            jsonArray2.add(menu2_3);
//            jsonArray2.add(menu2_4);
//            jsonArray2.add(menu2_5);
//            object2.put("sub_button", com.alibaba.fastjson2.JSONObject.toJSONString(jsonArray2));
//
//            //一级菜单 3
//            Map<String, String> object3 = new HashMap<>();
//            object3.put("name", "校园服务");
//            JSONArray jsonArray3 = new JSONArray();
//
//            //二级菜单 3-1
//            Map<String, String> menu3_1 = new HashMap<>();
//            object3.put("type", "view");
//            object3.put("name", "投稿");
//            object3.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            Map<String, String> menu3_2 = new HashMap<>();
//            object3.put("type", "view");
//            object3.put("name", "联系我们");
//            object3.put("url", "https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Creating_Custom-Defined_Menu.html");
//
//            jsonArray2.add(menu3_1);
//            jsonArray2.add(menu3_2);
//            object3.put("sub_button", com.alibaba.fastjson2.JSONObject.toJSONString(jsonArray3));
//
//            buttonAry.add(object1);
//            buttonAry.add(object2);
//            buttonAry.add(object3);
//
//            menu.put("button", buttonAry);
//            String results = HttpUtil.post(url, com.alibaba.fastjson2.JSONObject.toJSONString(menu));
//            return AjaxResult.success(results);
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            return AjaxResult.error();
//        }
//    }


    /**
     * @author lyric
     * @date 2022/10/16 13:28
     * <p>
     * 1.用户同意授权,获取code
     */
    @GetMapping("/getCode")
    public String getCode(HttpServletResponse response) throws IOException {
        log.info("调用getCode");
        // state 为开发者填写参数值
        String state = UUID.randomUUID().toString().replaceAll("-", "");
        // 微信公众平台
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?"
                + "appid="
                + "wx765a55464b308d13"
                + "&redirect_uri="
                + redirectUri
                + "&response_type=code"
                + "&scope="
                + "aa6741b17f05203975b17f0a64458741"
                + "&state=" + state + "#wechat_redirect";
//        response.sendRedirect(url);
        return "redirect:" + url;
    }

    /**
     * @author lyric
     * @date 2022/10/16 13:50
     * <p>
     * 2.通过code换取网页授权access_token 获取openId
     */
    @GetMapping("/callback")
    public AjaxResult callback(String code) {
        AjaxResult ajax = AjaxResult.success();
        log.info("接收到重定向消息");
        //封装获取openId的微信API
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid="
                + appid
                + "&secret="
                + appsecret
                + "&code="
                + code
                + "&grant_type=authorization_code";
        String result = HttpUtil.get(url);
        log.info("urlRespons:"+result);
        // 将结果解析为json
        JSONObject jsonObject = JSONUtil.parseObj(result);
//        System.out.println(result);
        String openId = jsonObject.getStr("openid");

//        if (StringUtils.isEmpty(openId)) {
//            throw new ServiceException("获取openId失败");
//        }
        ajax.put("openId", openId);
        log.info(openId);
        return ajax;
//        return "redirect:" + "http://y32025c600.goho.co:10087/#/?openId=" + openId;
//        return "redirect:" + "http://43.143.63.140:9000/#/?openId=" + openId;
//        return "redirect:" + "http://y32025c600.goho.co:10087/#/?openId=" + openId;
    }

    /**
     * @author lyric
     * @date 2022/10/20 13:10
     * 请假回复模板消息
     */
    @PostMapping("/sendTemplate")
    @ResponseBody
    public AjaxResult sendTemplate(@RequestBody LeaveTemplate leaveTemplate) {
        String result = wxApiService.sendTemplate(leaveTemplate);
        return AjaxResult.success(result);
    }

    /*
     <xml>
         <ToUserName><![CDATA[toUser]]></ToUserName>
         <FromUserName><![CDATA[fromUser]]></FromUserName>
         <CreateTime>12345678</CreateTime>
         <MsgType><![CDATA[news]]></MsgType>
         <ArticleCount>1</ArticleCount>
         <Articles>
             <item>
                 <Title><![CDATA[title1]]></Title>
                 <Description><![CDATA[description1]]></Description>
                 <PicUrl><![CDATA[picurl]]></PicUrl>
                 <Url><![CDATA[url]]></Url>
             </item>
         </Articles>
     </xml>
     */
}
