package yangtz.cs.liu.wechat.controller.api;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.core.domain.VerificationCodeParam;
import com.ruoyi.common.core.domain.AjaxResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.temp.AuditoriumTemplate;
import yangtz.cs.liu.wechat.service.api.IWxApiService;
import yangtz.cs.liu.wechat.utils.SignUtil;
import yangtz.cs.liu.wechat.utils.TimestampUtil;

/**
 * 微信模板推送
 */
@RestController()
@RequestMapping("/vx/temlateses")
public class VxTemlateController {

  @Autowired
  IWxApiService iWxApiService;

  private String ticketSecret = "71_0xakqv3T3ORjyXPeP-s2rwRcAqDbMEmmmkfMQeeJJmXBM8g-W4p4oa5BKisL-FYVHMzLJLyzbhgFQUfOkBW8Ufr4SWTTgGpjGs-BmIi8V95ct5hAXtQ47xDetjoLSSiAFAXEE";
  /**
   * {{first.DATA}}   标题
   * 申请人：{{keyword1.DATA}}
   * 申请内容：{{keyword2.DATA}}
   * 申请时间：{{keyword3.DATA}}
   * {{remark.DATA}}  备注信息
   * @return
   */
    @PostMapping("/sendTemlate")
    private AjaxResult sendTemlate(@RequestBody VerificationCodeParam param){
      Boolean flag = false;
      String msg = "";
      // 验证信息是否被篡改
      if(!SignUtil.validateMessage(param, ticketSecret)) {
        flag=true;
        msg="签名验证失败";
      }
      // 验证时间戳,防止重复提交
      Boolean validateResult = TimestampUtil.validateTimestamp("verificationCode", param.getTimeStamp());
      if(!validateResult) {
        flag = true;
        msg ="验证时间戳不合法";
       }
      if (flag){
       return AjaxResult.error(msg);
      }
      Map<String, Object> map = param.getMap();
      Date date =null;
      String applyTime = map.get("applyTime").toString();
      SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
      try {
         date = dateFormat.parse(applyTime);
      } catch (ParseException e) {
        e.printStackTrace();
      }

      // 发送模板
      AuditoriumTemplate auditoriumTemplate = new AuditoriumTemplate();
      auditoriumTemplate.setApplyTime(date);
      auditoriumTemplate.setRemark(map.get("remark").toString()==null ?"":map.get("remark").toString());
      auditoriumTemplate.setContent(map.get("content").toString()==null ?"":map.get("content").toString());
      auditoriumTemplate.setApplyUser(map.get("applyUser").toString()==null ?"":map.get("applyUser").toString());
      auditoriumTemplate.setToUserOpenId(map.get("toUserOpenId").toString()==null ?"":map.get("toUserOpenId").toString());
      auditoriumTemplate.setFirst(map.get("first").toString()==null ?"":map.get("first").toString());
      String s = iWxApiService.sendAuditoriumTemplate(auditoriumTemplate);
      return AjaxResult.success(s);
    }




}
