package yangtz.cs.liu.dingding.vo;

import com.aliyun.dingtalktodo_1_0.models.CreateTodoTaskRequest;
import com.aliyun.tea.NameInMap;
import lombok.Data;

import java.util.List;

/**
 * 任务管理
 */
@Data
public class DingSchoolTaskVo {

    /** 当前操作者用户的unionId */
    @NameInMap("operatorId")
    public String operatorId;

    /** 业务系统侧的唯一标识ID，即业务ID */
    @NameInMap("sourceId")
    public String sourceId;

    /** 待办标题，最大长度1024 */
    @NameInMap("subject")
    public String subject;

    /** 创建者的unionId */
    @NameInMap("creatorId")
    public String creatorId;

    /** 待办备注描述，最大长度4096 */
    @NameInMap("description")
    public String description;

    /** 截止时间，Unix时间戳，单位毫秒 */
    @NameInMap("dueTime")
    public Long dueTime;

    /** 执行者的unionId，最大数量1000 */
    @NameInMap("executorIds")
    public List<String> executorIds;

    /** 参与者的unionId，最大数量1000 */
    @NameInMap("participantIds")
    public List<String> participantIds;

    /** 详情页url跳转地址 */
    @NameInMap("detailUrl")
    public CreateTodoTaskRequest.CreateTodoTaskRequestDetailUrl detailUrl;

    /** 生成的待办是否仅展示在执行者的待办列表中 */
    @NameInMap("isOnlyShowExecutor")
    public Boolean isOnlyShowExecutor;

    /** 优先级，取值： 10：较低  20：普通  30：紧急  40：非常紧急 */
    @NameInMap("priority")
    public Integer priority;

    /** 待办通知配置 */
    @NameInMap("notifyConfigs")
    public CreateTodoTaskRequest.CreateTodoTaskRequestNotifyConfigs notifyConfigs;

    @NameInMap("actionList")
    public List<CreateTodoTaskRequest.CreateTodoTaskRequestActionList> actionList;
    @NameInMap("bizCategoryId")
    public String bizCategoryId;
    @NameInMap("contentFieldList")
    public List<CreateTodoTaskRequest.CreateTodoTaskRequestContentFieldList> contentFieldList;

}
