package yangtz.cs.liu.dingding.utils;

import com.aliyun.tea.TeaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangtz.cs.liu.dingding.vo.DingSchoolTaskVo;

/**
 * 待办已办任务
 */
@Component
public class DingTaskUtils {

    @Autowired
    private AccessTokenUtils accessTokenUtils;

    private static Logger log = LoggerFactory.getLogger(DingTaskUtils.class);

    /**
     * 使用 Token 初始化账号Client
     * @return Client
     * @throws Exception
     */
    public com.aliyun.dingtalktodo_1_0.Client createClient()  {
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config();
        config.protocol = "https";
        config.regionId = "central";
        try {
            return new com.aliyun.dingtalktodo_1_0.Client(config);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 创建待办任务
     */
    public void createTask(DingSchoolTaskVo taskVo) {
        //获取access_token
        String token = accessTokenUtils.getToken();
        com.aliyun.dingtalktodo_1_0.Client client = createClient();
        com.aliyun.dingtalktodo_1_0.models.CreateTodoTaskHeaders createTodoTaskHeaders = new com.aliyun.dingtalktodo_1_0.models.CreateTodoTaskHeaders();
        createTodoTaskHeaders.xAcsDingtalkAccessToken = token;
        com.aliyun.dingtalktodo_1_0.models.CreateTodoTaskRequest createTodoTaskRequest = new com.aliyun.dingtalktodo_1_0.models.CreateTodoTaskRequest()
                .setSourceId(taskVo.getSourceId())
                .setSubject(taskVo.getSubject())
                .setCreatorId(taskVo.getCreatorId())
                .setDescription(taskVo.getDescription())
                .setDueTime(taskVo.getDueTime())
                .setExecutorIds(taskVo.getExecutorIds())
                .setParticipantIds(taskVo.getParticipantIds())
                .setDetailUrl(taskVo.getDetailUrl())
                .setIsOnlyShowExecutor(taskVo.getIsOnlyShowExecutor())
                .setPriority(taskVo.getPriority())
                .setNotifyConfigs(taskVo.getNotifyConfigs())
                .setOperatorId(taskVo.getOperatorId());
        try {
            client.createTodoTaskWithOptions(taskVo.getCreatorId(), createTodoTaskRequest, createTodoTaskHeaders, new com.aliyun.teautil.models.RuntimeOptions());
        } catch (TeaException err) {
            if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
                // err 中含有 code 和 message 属性，可帮助开发定位问题
                log.info(err.code);
                log.info(err.message);
            }

        } catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), _err);
            if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
                // err 中含有 code 和 message 属性，可帮助开发定位问题
                log.info(err.code);
                log.info(err.message);
            }

        }
    }
}
