package yangtz.cs.liu.dingding.utils;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiAttendanceGetleavestatusRequest;
import com.dingtalk.api.request.OapiAttendanceGetupdatedataRequest;
import com.dingtalk.api.request.OapiAttendanceListRecordRequest;
import com.dingtalk.api.response.OapiAttendanceGetleavestatusResponse;
import com.dingtalk.api.response.OapiAttendanceGetupdatedataResponse;
import com.dingtalk.api.response.OapiAttendanceListRecordResponse;
import com.ruoyi.common.utils.StringUtils;
import com.taobao.api.ApiException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 考勤
 */
@Component
public class DingClockUtils {

    @Autowired
    private AccessTokenUtils accessTokenUtils;

    /**
     * 查询打卡记录详情
     * @param userIds 企业内的员工ID列表，最大值50。
     * @param checkDateFrom 查询考勤打卡记录的起始工作日  格式为：yyyy-MM-dd hh:mm:ss
     * @param checkDateTo 查询考勤打卡记录的结束工作日   格式为：yyyy-MM-dd hh:mm:ss
     * @param isI18n   是否为海外企业使用     true：海外平台使用    false（默认）：国内平台使用
     * @return
     */
    public List<OapiAttendanceListRecordResponse.Recordresult> listRecord(List<String> userIds,String checkDateFrom,String checkDateTo,Boolean isI18n){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/attendance/listRecord");
            OapiAttendanceListRecordRequest req = new OapiAttendanceListRecordRequest();
            req.setUserIds(userIds);
            req.setCheckDateFrom(checkDateFrom);
            req.setCheckDateTo(checkDateTo);
            req.setIsI18n(isI18n);
            OapiAttendanceListRecordResponse rsp = client.execute(req, token);
            return rsp.getRecordresult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new ArrayList<>();
    }

    /**
     * 获取用户考勤数据   获取指定用户当天的考勤数据   可获取用户的考勤数据，包括打卡流水记录、打卡结果和审批列表等
     * @param userId  用户的userId
     * @param workDate 查询日期
     * @return
     */
    public OapiAttendanceGetupdatedataResponse.AtCheckInfoForOpenVo getupdatedata(String userId, Date workDate){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/attendance/getupdatedata");
            OapiAttendanceGetupdatedataRequest req = new OapiAttendanceGetupdatedataRequest();
            req.setUserid(userId);
            req.setWorkDate(workDate);
            OapiAttendanceGetupdatedataResponse rsp = client.execute(req, token);
            return rsp.getResult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiAttendanceGetupdatedataResponse.AtCheckInfoForOpenVo();
    }

    /**
     * 查询请假状态   查询指定企业下指定用户在指定时间段内每天的请假状态和请假时长信息
     * @param userIds  待查询用户的ID列表，每次最多100个
     * @param startTime  开始时间 ，Unix时间戳，支持最多180天的查询
     * @param endTime  结束时间，Unix时间戳，支持最多180天的查询
     * @param offSet  支持分页查询，与size参数同时设置时才生效，此参数代表偏移量，偏移量从0开始
     * @param size  支持分页查询，与offset参数同时设置时才生效，此参数代表分页大小，最大20
     */
    public OapiAttendanceGetleavestatusResponse.LeaveStatusListVO getleavestatus(String userIds, Long startTime, Long endTime, Long offSet, Long size){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/attendance/getleavestatus");
            OapiAttendanceGetleavestatusRequest req = new OapiAttendanceGetleavestatusRequest();
            req.setUseridList(userIds);
            req.setStartTime(startTime);
            req.setEndTime(endTime);
            req.setOffset(offSet);
            req.setSize(size);
            OapiAttendanceGetleavestatusResponse rsp = client.execute(req, token);
            return rsp.getResult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiAttendanceGetleavestatusResponse.LeaveStatusListVO();
    }


}
