package yangtz.cs.liu.dingding.mapper.dingDept;

import yangtz.cs.liu.dingding.domain.dingDept.SysDdDept;

import java.util.List;
import java.util.Map;

public interface DdDeptMapper {

    /**
     * 查询系统部门列表
     * @param sysDdDept
     * @return
     */
    List<SysDdDept> selectDdDeptList(SysDdDept sysDdDept);

    /**
     * 根据钉钉部门id查询系统部门信息
     */
    SysDdDept selectDeptByDdDeptId(Long ddDeptId);

    /**
     * 根据部门id查询系统部门信息
     */
    SysDdDept selectDeptByDeptId(Long deptId);

    /**
     * 查询级部信息
     */
    List<Map<String,Object>> selectGradeList();

    /**
     * 新增钉钉部门
     * @return
     */
    int insertDdDept(SysDdDept sysDdDept);

    /**
     * 更新钉钉部门
     * @param sysDdDept
     * @return
     */
    int updateDdDeptByDdDeptId(SysDdDept sysDdDept);

    /**
     * 删除部门
     * @param deptId
     * @return
     */
    int deleteDdDeptById(Long deptId);

    /**
     * 根据钉钉部门id删除部门
     * @param ddDeptId
     * @return
     */
    int deleteDdDeptByDdDeptId(Long ddDeptId);
}
