package yangtz.cs.liu.dingding.controller.dingProcess;

import com.aliyun.dingtalkworkflow_1_0.models.ProcessForecastResponseBody;
import com.aliyun.dingtalkworkflow_1_0.models.QuerySchemaByProcessCodeResponseBody;
import com.aliyun.dingtalkworkflow_1_0.models.StartProcessInstanceRequest;
import com.ruoyi.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.dingding.utils.DingProcessInstanceUtils;
import yangtz.cs.liu.dingding.vo.DingHandleVo;
import yangtz.cs.liu.dingding.vo.DingProcessInstanceVo;
import yangtz.cs.liu.dingding.vo.DingTransferVo;
import java.util.Arrays;
import java.util.Map;

/**
 * 审批实例
 */
@RestController
@RequestMapping("/dd/school/instance")
public class DingProcessController {

    @Autowired
    private DingProcessInstanceUtils instanceUtils;

    /**
     * 发送审批实例
     */
    @PostMapping("/createInstance")
    public AjaxResult createInstance(@RequestBody DingProcessInstanceVo instanceVo){
        AjaxResult ajaxResult = AjaxResult.success();
        DingProcessInstanceVo dingProcessInstanceVo = new DingProcessInstanceVo();
//        StartProcessInstanceRequest.StartProcessInstanceRequestApprovers approvers = new StartProcessInstanceRequest.StartProcessInstanceRequestApprovers();
//        approvers.setActionType("NONE");
//        approvers.setUserIds(Arrays.asList("02144054095224351571"));
//        dingProcessInstanceVo.setApprovers(Arrays.asList(approvers));
        dingProcessInstanceVo.setOriginatorUserId("02144054095224351571");
        dingProcessInstanceVo.setDeptId(896846044L);
        dingProcessInstanceVo.setProcessCode("PROC-D907CDA3-F8C7-4E4F-8A8B-6A9E71287295");
        dingProcessInstanceVo.setCcList(Arrays.asList("02144054095224351571"));
        dingProcessInstanceVo.setCcPosition("START");
        StartProcessInstanceRequest.StartProcessInstanceRequestTargetSelectActioners targetSelectActioners = new StartProcessInstanceRequest.StartProcessInstanceRequestTargetSelectActioners();
        targetSelectActioners.setActionerKey("manual_1918_5cd3_de98_c68d");
        targetSelectActioners.setActionerUserIds(Arrays.asList("02144054095224351571"));
        dingProcessInstanceVo.setTargetSelectActioners(Arrays.asList(targetSelectActioners));
        StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues componentValues1 = new StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues();
        componentValues1.setName("请假类型");
        componentValues1.setValue("事假");
        componentValues1.setComponentType("DDSelectField");
        StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues componentValues2 = new StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues();
        componentValues2.setName("[\"开始时间\",\"结束时间\"]");
        componentValues2.setValue("[\"2023-09-20 08:00\",\"2019-09-20 18:00\"]");
        componentValues2.setComponentType("DDDateRangeField");
        StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues componentValues3 = new StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues();
        componentValues3.setName("请假事由");
        componentValues3.setValue("有事");
        componentValues3.setComponentType("TextField");
        dingProcessInstanceVo.setFormComponentValues(Arrays.asList(componentValues1,componentValues2,componentValues3));
        String instanceId = instanceUtils.sendProcessInstance(dingProcessInstanceVo);
        ajaxResult.put("instanceId",instanceId);
        return ajaxResult;
    }

    /**
     * 获取表单schema
     */
    @GetMapping("/getSchema")
    public AjaxResult getSchema(String processCode){
        QuerySchemaByProcessCodeResponseBody.QuerySchemaByProcessCodeResponseBodyResult schema = instanceUtils.getSchema(processCode);
        return AjaxResult.success(schema);
    }

    /**
     * 获取审批单流程中的节点信息
     */
    @PostMapping("/getForecast")
    public AjaxResult getForecast(@RequestBody DingProcessInstanceVo instanceVo){
        ProcessForecastResponseBody.ProcessForecastResponseBodyResult forecast = instanceUtils.getForecast(instanceVo);
        return AjaxResult.success(forecast);
    }

    /**
     * 获取指定用户可见的审批表单列表
     */
    @GetMapping("/getTemplates")
    public AjaxResult getTemplates(String userId, Long maxResults, Long nextToken){
        return AjaxResult.success(instanceUtils.getTemplates(userId,maxResults,nextToken));
    }

    /**
     * 获取当前企业所有可管理的表单
     */
    @GetMapping("/getManageTemplates")
    public AjaxResult getManageTemplates(String userId){
        return AjaxResult.success(instanceUtils.getManageTemplates(userId));
    }

    /**
     * 获取单个审批实例详情
     */
    @GetMapping("/getProcessInstance")
    public AjaxResult getProcessInstance(String processInstanceId){
        return AjaxResult.success(instanceUtils.getProcessInstance(processInstanceId));
    }

    /**
     * 撤销审批实例
     */
    @GetMapping("/terminate")
    public AjaxResult terminate(String processInstanceId, Boolean isSystem, String remark, String operatingUserId){
        return AjaxResult.success(instanceUtils.terminate(processInstanceId, isSystem, remark, operatingUserId));
    }

    /**
     * 同意或拒绝审批任务
     */
    @PostMapping("/handleProcessInstance")
    public AjaxResult handleProcessInstance(DingHandleVo handleVo){
        Map<String, Boolean> map = instanceUtils.handleProcessInstance(handleVo);
        return AjaxResult.success(map);
    }

    /**
     * 转交审批任务
     */
    @PostMapping("/transferInstance")
    public AjaxResult transferInstance(DingTransferVo transferVo){
        Boolean result = instanceUtils.transferInstance(transferVo);
        return AjaxResult.success(result);
    }

    /**
     * 获取用户待审批数量
     */
    @GetMapping("/getUserTodoTasksNumbers")
    public AjaxResult getUserTodoTasksNumbers(String userId){
        Integer userTodoTasksNumbers = instanceUtils.getUserTodoTasksNumbers(userId);
        return AjaxResult.success(userTodoTasksNumbers);
    }

}
