package yangtz.cs.liu.dingding.controller.dingMessage;

import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationGetsendprogressResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationGetsendresultResponse;
import com.ruoyi.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.dingding.utils.DingMessageUtils;
import yangtz.cs.liu.dingding.vo.DingMessageVo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 消息通知
 */
@RestController
@RequestMapping("/dd/school/message")
public class DingMessageController {

    @Autowired
    private DingMessageUtils dingMessageUtils;

    /**
     * 发送消息通知
     */
    @PostMapping("/sendMessage")
    public AjaxResult sendMessage(@RequestBody DingMessageVo messageVo){
        AjaxResult ajaxResult = AjaxResult.success();
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
        msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
        msg.getOa().getHead().setText("text");
        msg.getOa().getHead().setBgcolor("FFBBBBBB");
        msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
        msg.getOa().getBody().setAuthor("");
        msg.getOa().getBody().setContent("");
        msg.getOa().getBody().setTitle("测试请假审批消息通知");
        OapiMessageCorpconversationAsyncsendV2Request.Form form1 = new OapiMessageCorpconversationAsyncsendV2Request.Form();
        form1.setKey("开始时间");
        form1.setValue("2023-09-23 08:00");
        OapiMessageCorpconversationAsyncsendV2Request.Form form2 = new OapiMessageCorpconversationAsyncsendV2Request.Form();
        form2.setKey("结束时间");
        form2.setValue("2023-09-24 18:00");
        msg.getOa().getBody().setForm(Arrays.asList(form1,form2));
        msg.getOa().setPcMessageUrl("https://open.dingtalk.com/");
        msg.getOa().setMessageUrl("https://open.dingtalk.com/");
        msg.setMsgtype("oa");
        OapiMessageCorpconversationAsyncsendV2Request.StatusBar statusBar = new OapiMessageCorpconversationAsyncsendV2Request.StatusBar();
        statusBar.setStatusBg("0xFFF65E5E");
        statusBar.setStatusValue("进行中");
        msg.getOa().setStatusBar(statusBar);
        messageVo.setMsg(msg);
        messageVo.setToAllUser(false);
        messageVo.setUseridList("02144054095224351571");
        Long taskId = dingMessageUtils.sendMessage(messageVo);
        ajaxResult.put("taskId",taskId);
        return ajaxResult;
    }

    /**
     * 撤回工作通知消息
     */
    @GetMapping("/recallMessage")
    public AjaxResult recallMessage(Long taskId){
        String message = dingMessageUtils.recallMessage(taskId);
        return AjaxResult.success(message);
    }

    /**
     * 更新工作通知状态栏
     */
    @GetMapping("/updateStatusBar")
    public AjaxResult updateStatusBar(Long taskId, String statusValue, String statusBg){
        String message = dingMessageUtils.updateStatusBar(taskId, statusValue, statusBg);
        return AjaxResult.success(message);
    }

    /**
     * 获取工作通知消息的发送进度
     */
    @GetMapping("/getSendProgress")
    public AjaxResult getSendProgress(Long taskId){
        OapiMessageCorpconversationGetsendprogressResponse.AsyncSendProgress sendProgress = dingMessageUtils.getSendProgress(taskId);
        return AjaxResult.success(sendProgress);
    }

    /**
     * 获取工作通知消息的发送结果
     */
    @GetMapping("/getSendResult")
    public AjaxResult getSendResult(Long taskId){
        OapiMessageCorpconversationGetsendresultResponse.AsyncSendResult sendResult = dingMessageUtils.getSendResult(taskId);
        return AjaxResult.success(sendResult);
    }
}
