package yangtz.cs.liu.dingding.controller.dingDept;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.dingding.service.impl.dingDept.DdDeptServcieImpl;

@RestController
@RequestMapping("/dd/school/dept")
public class DdDeptController extends BaseController {

    @Autowired
    private DdDeptServcieImpl ddDeptServcie;

    /**
     * 获取钉钉全部部门列表
     */
    @GetMapping("/getDeptList")
    public TableDataInfo getDeptList(){
        return getDataTable(ddDeptServcie.getDeptList());
    }

    /**
     * 下拉钉钉部门列表到系统
     */
    @PostMapping("/addDdDept")
    public AjaxResult addDdDept(){
        return toAjax(ddDeptServcie.addDdDept());
    }

    /**
     * 同步钉钉部门列表
     */
    @GetMapping("/syncDdDept")
    public AjaxResult syncDdDept(){
        return AjaxResult.success(ddDeptServcie.syncDdDept());
    }
}
