package yangtz.cs.liu.dingding.controller.dingClock;

import com.ruoyi.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.dingding.service.dingClock.IDingClockService;

/**
 * 钉钉用户打卡记录
 */
@RestController
@RequestMapping("/dd/school/clock")
public class DingClockController {

    @Autowired
    private IDingClockService dingClockService;

    /**
     * 获取全部用户一周内打卡记录
     */
    @PostMapping("/getListRecord")
    public AjaxResult getListRecord(){
        return AjaxResult.success(dingClockService.getListRecord());
    }

    /**
     * 获取全部用户一周内请假记
     */
    @PostMapping("/getTeacherLeave")
    public AjaxResult getTeacherLeave(){
        return AjaxResult.success(dingClockService.getTeacherLeave());
    }
}
