package yangtz.cs.liu.campus.vo.schoolSecurity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

@Data
public class SchoolVideoConsultExternalVo extends BaseEntity
{

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 流程实例id */
    private String instanceId;

    /** 用户id */
    private Long userId;

    /** 姓名 */
    private String userName;

    /** 联系电话 */
    private Long phone;

    /** 身份证号 */
    private String idCard;

    /** 录像调用开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date videoStartTime;

    /** 录像调用结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date videoEndTime;

    /** 调取录像时间 */
    private String videoTime;

    /** 调阅位置 */
    private String location;

    /** 申请事由 */
    private String applyReason;

    /** 状态（0未提交，1信息技术中心负责人审核，2安保负责人审核，3安全管理中心负责人审核，4分管领导审核，5结束） */
    private String state;

    /** 申请人id */
    private Long applyUserId;

    /** 申请人 */
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 审批人id1 */
    private Long handUserId1;

    /** 审批人1 */
    private String handUserName1;

    /** 审批人1意见 */
    private String handUserOpinion1;

    /** 审批人1签名是否显示（1是，0否） */
    private String isSign1;

    /** 审批人id2 */
    private Long handUserId2;

    /** 审批人2 */
    private String handUserName2;

    /** 审批人2意见 */
    private String handUserOpinion2;

    /** 审批人2签名是否显示（1是，0否） */
    private String isSign2;

    /** 审批人id3 */
    private Long handUserId3;

    /** 审批人3 */
    private String handUserName3;

    /** 审批人3意见 */
    private String handUserOpinion3;

    /** 审批人3签名是否显示（1是，0否） */
    private String isSign3;

    /** 审批人id4 */
    private Long handUserId4;

    /** 审批人4 */
    private String handUserName4;

    /** 审批人4意见 */
    private String handUserOpinion4;

    /** 审批人4签名是否显示（1是，0否） */
    private String isSign4;

    /** 调取结果 */
    private String fetchResult;

    /** 附件信息集合 */
    private List<SchoolAccessory> schoolAccessoryList;
}
