package yangtz.cs.liu.campus.vo.schoolSecurity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolVehicleInOutVo extends BaseEntity
{
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 流程实例id */
    private String instanceId;

    /** 用户id */
    private Long userId;

    /** 用户名称 */
    private String userName;

    /** 联系电话 */
    private Long phone;

    /** 工作性质（1在编，2合同制，3代课，4其他） */
    private String jobNature;

    /** 预计在校工作开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date workStartTime;

    /** 预计在校工作结束时间 */
    private String workEndTime;

    /** 预计在校工作时间 */
    private String workTime;

    /** 现申请登记车号 */
    private String applyLicenseNumber;

    /** 车辆品牌 */
    private String brand;

    /** 车型 */
    private String carType;

    /** 已登记车辆车号 */
    private String oldLicenseNumber;

    /** 已登记车辆是否保留（1是，0否） */
    private String isRetain;

    /** 申请人id */
    private Long applyUserId;

    /** 申请人 */
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 申请人类型（（0教工 1职工）） */
    private String applyType;

    /** 状态（0未提交，1级部/处室审核，2分管领导审核，3已结束） */
    private String state;

    /** 申请人级部/处室id */
    private Long applyOrgid;

    /** 申请人级部/处室 */
    private String applyOrgname;

    /** 审批人id1 */
    private Long handUserId1;

    /** 审批人1 */
    private String handUserName1;

    /** 审批人1意见 */
    private String handUserOpinion1;

    /** 审批人1签名是否显示（1是，0否） */
    private String isSign1;

    /** 审批人id2 */
    private Long handUserId2;

    /** 审批人2 */
    private String handUserName2;

    /** 审批人2意见 */
    private String handUserOpinion2;

    /** 审批人2签名是否显示（1是，0否） */
    private String isSign2;
}
