package yangtz.cs.liu.campus.vo.schoolRewardsPunishments;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

@Data
public class SchoolScAwardsVo
{
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 比赛名称 */
    @Excel(name = "比赛名称")
    private String competitionName;

    /** 主办单位 */
    @Excel(name = "主办单位")
    private String organizer;

    /** 获奖名称 */
    @Excel(name = "获奖名称")
    private String awardsName;

    /** 主管部门id */
    private Long competentDeptId;

    /** 主管部门 */
    @Excel(name = "主管部门")
    private String competentDept;

    /** 获奖级别(字典) */
    @Excel(name = "获奖级别")
    private String awardsLevel;

    /** 部门主任id */
    private Long deptDirectorId;

    /** 部门主任 */
    @Excel(name = "部门主任")
    private String deptDirector;

    /** 获奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardsTime;

    /** 获奖类型(字典) */
    @Excel(name = "获奖类型")
    private String awardsType;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态(0未提交，1审核中，2通过，3驳回) */
    @Excel(name = "审核状态")
    private String auditState;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /** 更新者 */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    /** 是否删除 */
    @TableField(fill = FieldFill.INSERT)
    private String delFlag;

    //图片附件
    private List<SchoolAccessory> schoolAccessoryList;

    /** 开始时间 */
    private String startTime;

    /** 结束时间 */
    private String endTime;
}
